/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.justarod.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class JRSyncScreen
extends class_437 {
    private final class_1657 player;
    private final List<DataLine> dataList = new ArrayList<DataLine>();
    private int currentPage = 0;
    private final int itemsPerPage = 10;
    private int totalPages = 0;
    private class_4185 prevBtn;
    private class_4185 nextBtn;

    public JRSyncScreen(class_1657 player) {
        super(class_2561.method_30163((String)"\u8eab\u4f53\u72b6\u6001\u76d1\u63a7\u9762\u677f"));
        this.player = player;
    }

    protected void method_25426() {
        super.method_25426();
        this.prepareData();
        int btnWidth = 80;
        int btnHeight = 20;
        int bottomY = this.field_22790 - 40;
        int centerX = this.field_22789 / 2;
        this.prevBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u4e0a\u4e00\u9875"), button -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
            this.updateButtons();
        }).method_46434(centerX - 90, bottomY, btnWidth, btnHeight).method_46431();
        this.nextBtn = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u4e0b\u4e00\u9875"), button -> {
            if (this.currentPage < this.totalPages - 1) {
                ++this.currentPage;
            }
            this.updateButtons();
        }).method_46434(centerX + 10, bottomY, btnWidth, btnHeight).method_46431();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u5173\u95ed"), button -> this.method_25419()).method_46434(centerX - 40, bottomY + 25, 80, 20).method_46431());
        this.method_37063((class_364)this.prevBtn);
        this.method_37063((class_364)this.nextBtn);
        this.updateButtons();
    }

    private void prepareData() {
        this.dataList.clear();
        this.addEntry("\u6027\u522b", this.getGenderString(this.player));
        this.addEntry("\u4f53\u529b", String.format("%.2f", this.player.getPower()));
        this.addEntry("\u5f53\u524d\u751f\u7406\u5468\u671f", this.player.getMenstruationCycle().text);
        this.addEntry("\u6708\u7ecf\u75db\u82e6\u51cf\u8f7b\u5269\u4f59", this.formatTime(this.player.getMenstruationComfort()));
        this.addEntry("\u62e5\u6709\u5b50\u5bab", this.formatBool(this.player.hasUterus()));
        if (this.player.getPregnant() > 0) {
            this.addEntry("\u6000\u5b55\u8fdb\u5ea6/\u65f6\u95f4", this.formatTime(this.player.getPregnant()));
        } else {
            this.addEntry("\u662f\u5426\u6000\u5b55", "\u5426");
        }
        this.addEntry("\u80da\u80ce\u7c7b\u578b", this.formatEntityType(this.player.getChildrenType()));
        this.addEntry("\u80ce\u513f\u6570\u91cf", String.valueOf(this.player.getBabyCount()));
        this.addEntry("\u6b63\u5728\u907f\u5b55", this.formatIntBool(this.player.getBrithControlling()));
        this.addEntry("\u7edd\u80b2\u72b6\u6001", this.formatBool(this.player.isSterilization()));
        this.addEntry("\u5bab\u5916\u5b55", this.formatBool(this.player.isEctopicPregnancy()));
        this.addEntry("\u8461\u8404\u80ce", this.formatBool(this.player.isHydatidiformMole()));
        this.addEntry("\u591a\u56ca\u5375\u5de2 (PCOS)", this.formatBool(this.player.isPCOS()));
        this.addEntry("\u827e\u6ecb\u75c5 (AIDS)", this.formatIntBool(this.player.getAids()));
        this.addEntry("\u827e\u6ecb\u514d\u75ab", this.formatBool(this.player.isImmune2Aids()));
        this.addEntry("\u6885\u6bd2 (Syphilis)", this.formatIntBool(this.player.getSyphilis()));
        this.addEntry("HPV \u611f\u67d3", this.formatIntBool(this.player.getHPV()));
        this.addEntry("HPV \u514d\u75ab", this.formatBool(this.player.isImmune2HPV()));
        this.addEntry("\u5375\u5de2\u764c", this.formatIntBool(this.player.getOvarianCancer()));
        this.addEntry("\u4e73\u817a\u764c", this.formatIntBool(this.player.getBreastCancer()));
        this.addEntry("\u622a\u80a2\u72b6\u6001", this.formatBool(this.player.isAmputated()));
        this.addEntry("\u777e\u4e38\u5207\u9664", this.formatBool(this.player.isOrchiectomy()));
        this.addEntry("\u6392\u6cc4\u503c", String.valueOf(this.player.getExcretion()));
        this.addEntry("\u6392\u5c3f\u503c", String.valueOf(this.player.getUrination()));
        this.totalPages = (int)Math.ceil((double)this.dataList.size() / 10.0);
        if (this.currentPage >= this.totalPages && this.totalPages > 0) {
            this.currentPage = this.totalPages - 1;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        context.method_27534(this.field_22793, class_2561.method_30163((String)String.format("\u7b2c %d / %d \u9875", this.currentPage + 1, Math.max(1, this.totalPages))), this.field_22789 / 2, this.field_22790 - 65, 0xAAAAAA);
        int startY = 40;
        int lineHeight = 12;
        int startIdx = this.currentPage * 10;
        int endIdx = Math.min(startIdx + 10, this.dataList.size());
        for (int i = startIdx; i < endIdx; ++i) {
            DataLine line = this.dataList.get(i);
            int relativeIndex = i - startIdx;
            int y = startY + relativeIndex * lineHeight;
            context.method_27535(this.field_22793, class_2561.method_30163((String)(line.key + ": ")), this.field_22789 / 2 - 100, y, 0xAAAAAA);
            context.method_27535(this.field_22793, class_2561.method_30163((String)line.value), this.field_22789 / 2 + 10, y, this.getColorForValue(line.value));
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void updateButtons() {
        if (this.prevBtn != null) {
            boolean bl = this.prevBtn.field_22763 = this.currentPage > 0;
        }
        if (this.nextBtn != null) {
            this.nextBtn.field_22763 = this.currentPage < this.totalPages - 1;
        }
    }

    private void addEntry(String key, String value) {
        this.dataList.add(new DataLine(key, value));
    }

    private String formatTime(int ticks) {
        if (ticks <= 0) {
            return "0";
        }
        double minutes = (double)ticks / 1200.0;
        if (minutes < 0.1) {
            return "< 0.1 \u5206\u949f";
        }
        return String.format("%.1f \u5206\u949f", minutes);
    }

    private String getGenderString(class_1657 p) {
        boolean isMale = p.isMale();
        boolean isFemale = p.isFemale();
        if (isMale && isFemale) {
            return "\u6276\u4ed6";
        }
        if (isMale) {
            return "\u7537";
        }
        if (isFemale) {
            return "\u5973";
        }
        return "\u65e0\u6027\u522b";
    }

    private String formatBool(boolean val) {
        return val ? "\u662f" : "\u5426";
    }

    private String formatIntBool(int val) {
        return val > 0 ? "\u662f" : "\u5426";
    }

    private String formatEntityType(Object optRaw) {
        Object t;
        Optional opt;
        if (optRaw instanceof Optional && (opt = (Optional)optRaw).isPresent() && (t = opt.get()) instanceof class_1299) {
            class_1299 type = (class_1299)t;
            return type.method_5897().getString();
        }
        return "\u65e0";
    }

    private int getColorForValue(String val) {
        if (val.equals("\u662f") || val.contains("\u5206\u949f")) {
            return 0xFF5555;
        }
        if (val.equals("\u5426") || val.equals("0")) {
            return 0x55FF55;
        }
        if (val.equals("\u65e0")) {
            return 0xAAAAAA;
        }
        if (val.equals("\u7537") || val.equals("\u5973") || val.equals("\u6276\u4ed6")) {
            return 0xFFFF55;
        }
        return 0xFFFFFF;
    }

    private record DataLine(String key, String value) {
    }
}

