/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.justarod.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#J#\u0010$\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b$\u0010%J/\u0010'\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b'\u0010(JG\u00101\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\b2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b1\u00102J'\u00104\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u00103\u001a\u00020.H\u0014\u00a2\u0006\u0004\b4\u00105J7\u00109\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010*\u001a\u00020)2\u0006\u00106\u001a\u00020)2\u0006\u00108\u001a\u000207H\u0002\u00a2\u0006\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lorg/cneko/justarod/item/WhipItem;", "Lnet/minecraft/class_1792;", "Lnet/minecraft/class_1792$class_1793;", "settings", "<init>", "(Lnet/minecraft/class_1792$class_1793;)V", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_1309;", "target", "attacker", "", "postHit", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1309;Lnet/minecraft/class_1309;)Z", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_1297;", "entity", "", "slot", "selected", "", "inventoryTick", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;IZ)V", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "Lnet/minecraft/class_1271;", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "finishUsing", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_1839;", "getUseAction", "(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1839;", "getMaxUseTime", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1309;)I", "remainingUseTicks", "onStoppedUsing", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;I)V", "", "range", "knockbackStrength", "slownessDuration", "slownessLevel", "", "damage", "charged", "applyWhipEffect", "(Lnet/minecraft/class_1309;DDIIFZ)V", "amount", "hitTarget", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1309;F)V", "angleRange", "Lnet/minecraft/class_2394;", "particle", "spawnWhipArcParticles", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1309;DDLnet/minecraft/class_2394;)V", "JustARod"})
public class WhipItem
extends class_1792 {
    public WhipItem(@NotNull class_1792.class_1793 settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings.method_7889(1).method_7895(1000));
    }

    public boolean method_7873(@NotNull class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        this.applyWhipEffect(attacker, 4.0, 0.4, 40, 1, 2.0f, false);
        return super.method_7873(stack, target, attacker);
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1297 entity, int slot, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.method_7888(stack, world, entity, slot, selected);
        if (world.field_9236 && selected && entity instanceof class_1657 && ((class_1657)entity).method_6115() && Intrinsics.areEqual((Object)((class_1657)entity).field_6277, (Object)stack)) {
            int useTicks = ((class_1657)entity).method_6048();
            double chargeRatio = Math.min((double)(this.method_7881(stack, (class_1309)entity) - useTicks) / (double)this.method_7881(stack, (class_1309)entity), 1.0);
            int particleCount = (int)((double)2 + (double)4 * chargeRatio);
            double yawRad = Math.toRadians(((class_1657)entity).method_36454());
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (-0.5 + Math.random()) * 0.3;
                double offsetY = (-0.5 + Math.random()) * 0.3;
                double offsetZ = (-0.5 + Math.random()) * 0.3;
                double x = ((class_1657)entity).method_23317() - Math.sin(yawRad) * 0.5 + offsetX;
                double y = ((class_1657)entity).method_23320() - 0.3 + offsetY;
                double z = ((class_1657)entity).method_23321() + Math.cos(yawRad) * 0.5 + offsetZ;
                float r = 0.2f * (float)(1.0 - chargeRatio);
                float g = 0.6f * (float)(1.0 - chargeRatio);
                float b = (float)(0.5 + 0.5 * chargeRatio);
                float size = 0.1f + 0.2f * (float)chargeRatio;
                world.method_8406((class_2394)new class_2390(new Vector3f(r, g, b), size), x, y, z, 0.0, 0.02, 0.0);
            }
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        user.method_6019(hand);
        class_1271 class_12712 = class_1271.method_22428((Object)user.method_5998(hand));
        Intrinsics.checkNotNullExpressionValue((Object)class_12712, (String)"consume(...)");
        return class_12712;
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1309 user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return stack;
    }

    @NotNull
    public class_1839 method_7853(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return class_1839.field_8953;
    }

    public int method_7881(@Nullable class_1799 stack, @Nullable class_1309 user) {
        return 30;
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 world, @NotNull class_1309 user, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!(user instanceof class_1657)) {
            return;
        }
        int chargedTicks = this.method_7881(stack, user) - remainingUseTicks;
        double chargeRatio = Math.min((double)chargedTicks / (double)this.method_7881(stack, user), 1.0);
        double range = 4.0 + 4.0 * chargeRatio;
        double knockback = 0.4 + 0.6 * chargeRatio;
        int duration = 40 + (int)((double)20 * chargeRatio);
        float damage = (float)((double)4.0f + (double)4.0f * chargeRatio);
        this.applyWhipEffect(user, range, knockback, duration, 2, damage, true);
        world.method_8396(null, ((class_1657)user).method_24515(), class_3417.field_15093, class_3419.field_15248, 1.0f, 0.8f + 0.4f * (float)chargeRatio);
        world.method_8396(null, ((class_1657)user).method_24515(), class_3417.field_14706, class_3419.field_15248, 0.8f, 1.0f);
        stack.method_7970(2 + (int)(chargeRatio * (double)2), user, class_1304.field_6173);
    }

    private final void applyWhipEffect(class_1309 attacker, double range, double knockbackStrength, int slownessDuration, int slownessLevel, float damage, boolean charged) {
        class_1937 world = attacker.method_37908();
        double angleRange = Math.toRadians(60.0);
        double attackerYaw = Math.toRadians(attacker.method_36454());
        class_2400 arcParticle = charged ? class_2398.field_29644 : class_2398.field_11227;
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNull((Object)arcParticle);
        this.spawnWhipArcParticles(world, attacker, range, angleRange, (class_2394)arcParticle);
        List entities = world.method_8390(class_1309.class, attacker.method_5829().method_1014(range), arg_0 -> WhipItem.applyWhipEffect$lambda$1(arg_0 -> WhipItem.applyWhipEffect$lambda$0(attacker, range, arg_0), arg_0));
        for (class_1309 entity : entities) {
            class_243 directionToEntity = entity.method_19538().method_1020(attacker.method_19538()).method_1029();
            class_243 attackerLookVec = new class_243(-Math.sin(attackerYaw), 0.0, Math.cos(attackerYaw));
            double dot = attackerLookVec.method_1026(directionToEntity);
            double angle = Math.acos(RangesKt.coerceIn((double)dot, (double)-1.0, (double)1.0));
            if (!(angle <= angleRange / (double)2)) continue;
            world.method_8406((class_2394)class_2398.field_11205, entity.method_23317(), entity.method_23320(), entity.method_23321(), 0.0, 0.0, 0.0);
            entity.method_6092(new class_1293(class_1294.field_5909, slownessDuration, slownessLevel));
            entity.method_5762(-Math.sin(attackerYaw) * knockbackStrength, 0.1, Math.cos(attackerYaw) * knockbackStrength);
            entity.field_6037 = true;
            Intrinsics.checkNotNull((Object)entity);
            this.hitTarget(attacker, entity, damage);
        }
    }

    protected void hitTarget(@NotNull class_1309 attacker, @NotNull class_1309 target, float amount) {
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        class_1282 damageSource = attacker.method_48923().method_48812(attacker);
        target.method_5643(damageSource, amount);
    }

    private final void spawnWhipArcParticles(class_1937 world, class_1309 attacker, double range, double angleRange, class_2394 particle) {
        double yawRad = Math.toRadians(attacker.method_36454());
        int steps = 10;
        int arcSteps = 6;
        int r = 1;
        while (true) {
            double radius = (double)r / (double)steps * range;
            int a = -arcSteps;
            if (a <= arcSteps) {
                while (true) {
                    double angleOffset = (double)a / (double)arcSteps * (angleRange / (double)2);
                    double x = attacker.method_23317() - Math.sin(yawRad + angleOffset) * radius;
                    double z = attacker.method_23321() + Math.cos(yawRad + angleOffset) * radius;
                    double y = attacker.method_23320() - 0.3;
                    world.method_8406(particle, x, y, z, 0.0, 0.0, 0.0);
                    if (a == arcSteps) break;
                    ++a;
                }
            }
            if (r == steps) break;
            ++r;
        }
    }

    private static final boolean applyWhipEffect$lambda$0(class_1309 $attacker, double $range, class_1309 it) {
        Intrinsics.checkNotNullParameter((Object)$attacker, (String)"$attacker");
        return !Intrinsics.areEqual((Object)it, (Object)$attacker) && $attacker.method_24516((class_1297)it, $range);
    }

    private static final boolean applyWhipEffect$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

