/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.justarod.entity;

import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_7923;
import org.cneko.justarod.JRAttributes;
import org.cneko.justarod.effect.JREffects;
import org.jetbrains.annotations.NotNull;

public interface Powerable {
    default public double getPower() {
        return 0.0;
    }

    default public void setPower(double power) {
        throw new UnsupportedOperationException("This entity is not Powerable");
    }

    default public boolean canPowerUp() {
        return true;
    }

    default public double readPowerFromNbt(@NotNull class_2487 nbt) {
        if (nbt.method_10545("power")) {
            return nbt.method_10574("power");
        }
        return 100.0;
    }

    default public void writePowerToNbt(@NotNull class_2487 nbt) {
        nbt.method_10549("power", this.getPower());
    }

    public static <E extends class_1309> void tickPower(@NotNull E entity) {
        if (((Powerable)entity).canPowerUp()) {
            Powerable.powerUp(entity, 0.01);
        }
        ((Powerable)entity).setPower(Math.min(((Powerable)entity).getPower(), Powerable.getMaxPower(entity)));
        if (((Powerable)entity).getPower() <= 0.0) {
            ((Powerable)entity).setPower(0.0);
            entity.method_6092(new class_1293(class_7923.field_41174.method_47983((Object)JREffects.Companion.getFAINT_EFFECT()), 1000, 1));
        }
    }

    public static <E extends class_1309> double getMaxPower(@NotNull E entity) {
        return entity.method_45325(JRAttributes.Companion.getGENERIC_MAX_POWER());
    }

    public static <E extends class_1309> void powerUp(E e, double amount) {
        double power = ((Powerable)e).getPower();
        ((Powerable)e).setPower(power + amount);
    }
}

