/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.ctlibPublic.File;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration {
    private Map<String, Object> data;
    private final Path path;

    public YamlConfiguration(Path path) throws IOException {
        this.path = path;
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                Yaml yaml = new Yaml();
                this.data = (Map)yaml.load(in);
            }
        } else {
            this.data = new LinkedHashMap<String, Object>();
        }
    }

    public Object get(String path) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            if ((current = (Map)current.get(keys[i])) != null) continue;
            return null;
        }
        return current.get(keys[keys.length - 1]);
    }

    public void set(String path, Object value) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            current = (Map)current.computeIfAbsent((String)keys[i], k -> new LinkedHashMap());
        }
        current.put(keys[keys.length - 1], value);
    }

    public void save() throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (OutputStream out = Files.newOutputStream(this.path, new OpenOption[0]);){
            yaml.dump(this.data, new OutputStreamWriter(out));
        }
    }

    public String getString(String path) {
        return (String)this.get(path);
    }

    public int getInt(String path) {
        return (Integer)this.get(path);
    }

    public boolean getBoolean(String path) {
        return (Boolean)this.get(path);
    }
}

