/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.network;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.cneko.ctlib.common.file.JsonConfiguration;
import org.cneko.ctlib.common.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class HttpGet {

    public static class HttpGetObject {
        private String url;
        private Map<String, String> headers;
        private String response;
        private int responseCode = 0;
        private String responseHeaders;

        public HttpGetObject(@NotNull String url, @Nullable Map<String, String> headers) {
            this.url = url;
            this.headers = headers;
        }

        public void get() throws IOException {
            int responseCode;
            URL u = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            this.responseCode = responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                this.response = response.toString();
            } else {
                this.response = null;
            }
            Map<String, List<String>> map = conn.getHeaderFields();
            StringBuilder headers = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                headers.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
            this.responseHeaders = headers.toString();
        }

        public void asyncGet() {
            new Thread(() -> {
                try {
                    this.get();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }).start();
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public String getResponse() {
            return this.response;
        }

        public String getResponseHeaders() {
            return this.responseHeaders;
        }

        public int getStatusCode() {
            return this.responseCode;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void saveToFile(Path path) throws IOException {
            if (this.response != null) {
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(this.response);
                }
            } else {
                throw new IllegalStateException("Response is null, cannot save to file.");
            }
        }

        public JsonConfiguration getJson() {
            return new JsonConfiguration(this.response);
        }

        public YamlConfiguration getYaml() {
            return new YamlConfiguration(this.response);
        }
    }

    public static class SimpleHttpGet {
        public static String get(@NotNull String url, @Nullable Map<String, String> headers) throws IOException {
            int responseCode;
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if ((responseCode = conn.getResponseCode()) == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                return response.toString();
            }
            return null;
        }

        public static void AsyncGet(@NotNull String url, @Nullable Map<String, String> headers) {
            new Thread(() -> {
                try {
                    SimpleHttpGet.get(url, headers);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }).start();
        }

        public static String getString(@NotNull String url, @Nullable Map<String, String> headers, String defaultValue) {
            try {
                String response = SimpleHttpGet.get(url, headers);
                return response != null ? response : defaultValue;
            }
            catch (IOException e) {
                return defaultValue;
            }
        }

        public static JsonConfiguration getJson(@NotNull String url, @Nullable Map<String, String> headers) throws IOException {
            String jsonString = SimpleHttpGet.get(url, headers);
            return new JsonConfiguration(jsonString);
        }

        public static boolean getFile(@NotNull String path, @NotNull String url, @Nullable Map<String, String> headers) throws IOException {
            int responseCode;
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if ((responseCode = conn.getResponseCode()) == 200) {
                int len;
                InputStream in = conn.getInputStream();
                FileOutputStream out = new FileOutputStream(new File(path));
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
                return true;
            }
            return false;
        }

        public static void asyncGetFile(@NotNull String path, @NotNull String url, @Nullable Map<String, String> headers) {
            new Thread(() -> {
                try {
                    boolean bl = SimpleHttpGet.getFile(path, url, headers);
                }
                catch (IOException e) {
                    System.out.println("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:" + e.getMessage());
                }
            }).start();
        }
    }
}

