/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.cneko.ctlib.common.file.Configure;

public class PropertiesConfigure
implements Configure {
    private final Properties properties = new Properties();

    public PropertiesConfigure(Path filePath) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(filePath.toFile());){
            this.properties.load(fileInputStream);
        }
    }

    @Override
    public Object get(String path) {
        return this.properties.getProperty(path);
    }

    @Override
    public void set(String path, Object value) {
        throw new UnsupportedOperationException("Setting properties is not supported.");
    }

    @Override
    public void save() throws IOException {
        throw new UnsupportedOperationException("Saving properties is not supported.");
    }

    @Override
    public String getString(String path) {
        return this.properties.getProperty(path);
    }

    @Override
    public List<String> getStringList(String path) {
        return new ArrayList<String>();
    }

    @Override
    public float getFloat(String path) {
        String value = this.properties.getProperty(path);
        return value != null ? Float.parseFloat(value) : 0.0f;
    }

    @Override
    public double getDouble(String path) {
        String value = this.properties.getProperty(path);
        return value != null ? Double.parseDouble(value) : 0.0;
    }

    @Override
    public int getInt(String path) {
        String value = this.properties.getProperty(path);
        return value != null ? Integer.parseInt(value) : 0;
    }

    @Override
    public boolean getBoolean(String path) {
        String value = this.properties.getProperty(path);
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean getBoolean(String path, boolean defValue) {
        String value = this.properties.getProperty(path);
        return value != null ? Boolean.parseBoolean(value) : defValue;
    }

    @Override
    public boolean isSet(String path) {
        return this.properties.containsKey(path);
    }

    @Override
    public boolean contains(String path) {
        return this.properties.containsKey(path);
    }

    @Override
    public ArrayList<Integer> getIntList(String path) {
        return new ArrayList<Integer>();
    }

    @Override
    public ArrayList<Double> getDoubleList(String path) {
        return new ArrayList<Double>();
    }

    @Override
    public ArrayList<Float> getFloatList(String path) {
        return new ArrayList<Float>();
    }

    @Override
    public ArrayList<Object> getList(String path) {
        return new ArrayList<Object>();
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PropertiesConfigure && this.properties.equals(((PropertiesConfigure)obj).properties);
    }

    @Override
    public boolean equalsCaseIgnoreCase(Object obj) {
        return this.equals(obj);
    }
}

