/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class LocalDataBase {

    public static class Sqlite
    implements Sql {
        public Connection connection;
        public String sqlPath;

        public Sqlite(String path) throws SQLException {
            this.sqlPath = path;
            this.connection = this.createConnection();
        }

        private Connection createConnection() throws SQLException {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            File sqliteFile = new File(this.sqlPath);
            if (!sqliteFile.exists()) {
                File parentDir = sqliteFile.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                try {
                    sqliteFile.createNewFile();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
            String connectionUrl = "jdbc:sqlite:" + this.sqlPath;
            this.connection = DriverManager.getConnection(connectionUrl);
            return this.connection;
        }

        @Override
        public void executeSQL(String sql) {
            try (Statement statement = this.connection.createStatement();){
                statement.execute(sql);
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        @Override
        public void disconnect() {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        @Override
        public void saveData(String tableName, String columnName, String data) {
            if (!this.isTableExists(tableName)) {
                this.createTable(tableName);
            }
            this.addColumn(tableName, columnName);
            String query = "INSERT INTO " + tableName + " (" + columnName + ") VALUES (?)";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, data);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean checkValueExists(String tableName, String columnName, String value) {
            String query = "SELECT COUNT(*) FROM " + tableName + " WHERE " + columnName + " = ?";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, value);
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) return false;
                int count = resultSet.getInt(1);
                boolean bl = count > 0;
                return bl;
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
            return false;
        }

        @Override
        public void saveDataWhere(String tableName, String columnName, String whereName, String whereValue, String columnValue) {
            if (!this.isTableExists(tableName)) {
                this.createTable(tableName);
            }
            String query = "UPDATE " + tableName + " SET " + columnName + " = ? WHERE " + whereName + " = ?";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, columnValue);
                statement.setString(2, whereValue);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getColumnValue(String tableName, String columnName, String whereName, String whereValue) {
            String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + whereName + "=?";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.setString(1, whereValue);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (!resultSet.next()) return null;
                    String string = resultSet.getString(columnName);
                    return string;
                }
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
            return null;
        }

        @Override
        public String[] readAllValueInAColumn(String tableName, String columnName) {
            String[] stringArray;
            block9: {
                String query = "SELECT " + columnName + " FROM " + tableName;
                PreparedStatement statement = this.connection.prepareStatement(query);
                try {
                    ResultSet result = statement.executeQuery();
                    ArrayList<String> names = new ArrayList<String>();
                    while (result.next()) {
                        String name = result.getString(columnName);
                        names.add(name);
                    }
                    String[] namesArray = new String[names.size()];
                    names.toArray(namesArray);
                    stringArray = namesArray;
                    if (statement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        return new String[0];
                    }
                }
                statement.close();
            }
            return stringArray;
        }

        @Override
        public boolean deleteLine(String tableName, String whereColumn, String whereValue) {
            boolean bl;
            block8: {
                String query = "DELETE FROM " + tableName + " WHERE " + whereColumn + " = ?";
                PreparedStatement statement = this.connection.prepareStatement(query);
                try {
                    statement.setString(1, whereValue);
                    statement.executeUpdate();
                    bl = true;
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        return false;
                    }
                }
                statement.close();
            }
            return bl;
        }

        @Override
        public boolean isTableExists(String tableName) {
            try {
                DatabaseMetaData metaData = this.connection.getMetaData();
                ResultSet resultSet = metaData.getTables(null, null, tableName, null);
                return resultSet.next();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                return false;
            }
        }

        @Override
        public void createTable(String tableName) {
            String query = "CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY AUTOINCREMENT)";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.executeUpdate();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        @Override
        public boolean isColumnExists(String tableName, String columnName) {
            try {
                DatabaseMetaData metaData = this.connection.getMetaData();
                ResultSet resultSet = metaData.getColumns(null, null, tableName, columnName);
                return resultSet.next();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                return false;
            }
        }

        @Override
        public void addColumn(String tableName, String columnName) {
            if (this.checkColumnExists(tableName, columnName)) {
                return;
            }
            String query = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " TEXT";
            try (PreparedStatement statement = this.connection.prepareStatement(query);){
                statement.executeUpdate();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }

        @Override
        public boolean checkColumnExists(String tableName, String columnName) {
            boolean bl;
            block8: {
                ResultSet resultSet = this.connection.getMetaData().getColumns(null, null, tableName, columnName);
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        System.out.println(e.getMessage());
                        return false;
                    }
                }
                resultSet.close();
            }
            return bl;
        }

        @Override
        public ResultSet executeSQLWithParams(String sql, @Nullable String[] replaces) {
            try {
                PreparedStatement statement = this.connection.prepareStatement(sql);
                if (replaces != null) {
                    for (int i = 0; i < replaces.length; ++i) {
                        statement.setString(i + 1, replaces[i]);
                    }
                }
                if (sql.trim().toLowerCase().startsWith("select")) {
                    return statement.executeQuery();
                }
                statement.executeUpdate();
                statement.close();
                return null;
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                return null;
            }
        }
    }

    public static interface Sql {
        public void executeSQL(String var1);

        public void disconnect();

        public void saveData(String var1, String var2, String var3);

        public boolean checkValueExists(String var1, String var2, String var3);

        public void saveDataWhere(String var1, String var2, String var3, String var4, String var5);

        public String getColumnValue(String var1, String var2, String var3, String var4);

        public String[] readAllValueInAColumn(String var1, String var2);

        public boolean deleteLine(String var1, String var2, String var3);

        public boolean isTableExists(String var1);

        public void createTable(String var1);

        public boolean isColumnExists(String var1, String var2);

        public void addColumn(String var1, String var2);

        public boolean checkColumnExists(String var1, String var2);

        public ResultSet executeSQLWithParams(String var1, String[] var2);
    }

    public static class Connections {
        public static Sqlite sqlite;

        static {
            try {
                sqlite = new Sqlite("ctlib/playerData.db");
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

