/*
 * Decompiled with CFR 0.152.
 */
package net.byteflux.libby.logging.adapters;

import cn.nukkit.plugin.PluginLogger;
import java.util.Objects;
import net.byteflux.libby.logging.LogLevel;
import net.byteflux.libby.logging.adapters.LogAdapter;

public class NukkitLogAdapter
implements LogAdapter {
    private final PluginLogger logger;

    public NukkitLogAdapter(PluginLogger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(LogLevel level, String message) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.debug(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARN: {
                this.logger.warning(message);
                break;
            }
            case ERROR: {
                this.logger.error(message);
            }
        }
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.debug(message, throwable);
                break;
            }
            case INFO: {
                this.logger.info(message, throwable);
                break;
            }
            case WARN: {
                this.logger.warning(message, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(message, throwable);
            }
        }
    }
}

