/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChatPrefix {
    public static String[] prefixes = new String[0];
    public static Map<String, List<String>> privatePrefixes = new HashMap<String, List<String>>();

    public static void addPublicPrefix(String prefix) {
        prefixes = Arrays.copyOf(prefixes, prefixes.length + 1);
        ChatPrefix.prefixes[ChatPrefix.prefixes.length - 1] = prefix;
    }

    public static void removePublicPrefix(String prefixName) {
        ArrayList<String> prefixList = new ArrayList<String>(Arrays.asList(prefixes));
        prefixList.remove(prefixName);
        prefixes = prefixList.toArray(new String[0]);
    }

    public static void addPrivatePrefix(String name, String prefixValue) {
        privatePrefixes.computeIfAbsent(name, k -> new ArrayList()).add(prefixValue);
    }

    public static void removePrivatePrefix(String name, String prefixValue) {
        List<String> playerPrefixes = privatePrefixes.get(name);
        if (playerPrefixes != null) {
            playerPrefixes.remove(prefixValue);
        }
    }

    public static String getAllPublicPrefixValues() {
        StringBuilder result = new StringBuilder();
        for (String prefix : prefixes) {
            result.append("[").append(prefix).append("\u00a7f\u00a7r]");
        }
        return result.toString();
    }

    public static String getPrivatePrefix(String name) {
        List<String> playerPrefixes = privatePrefixes.get(name);
        if (playerPrefixes != null && !playerPrefixes.isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (String prefix : playerPrefixes) {
                result.append("[").append(prefix).append("\u00a7f\u00a7r]");
            }
            return result.toString();
        }
        return " ";
    }

    public static String[] getAllPublicPrefixRawValues() {
        return prefixes;
    }

    public static List<String> getPrivatePrefixRawValues(String name) {
        return privatePrefixes.getOrDefault(name, new ArrayList());
    }
}

