/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonConfiguration {
    private Map<String, Object> configData;
    private Gson gson;
    private Path filePath;

    public JsonConfiguration(Path filePath) throws IOException {
        this.filePath = filePath;
        this.gson = new Gson();
        this.configData = this.loadConfigData(filePath);
    }

    public JsonConfiguration(String jsonString) {
        this.gson = new Gson();
        this.configData = jsonString == null ? new HashMap<String, Object>() : (Map)this.gson.fromJson(jsonString, new TypeToken<Map<String, Object>>(){}.getType());
    }

    private Map<String, Object> loadConfigData(Path filePath) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(filePath.toFile());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                return map;
            }
        }
        return new HashMap<String, Object>();
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Map || value instanceof List) {
            return new Gson().toJson(value);
        }
        return null;
    }

    public int getInt(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).intValue() : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getDouble(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).doubleValue() : 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public float getFloat(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).floatValue() : 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public boolean getBoolean(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Boolean ? (Boolean)value : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            Object value = this.get(key);
            return value instanceof Boolean ? (Boolean)value : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Object get(String key) {
        String[] keys = key.split("\\.");
        Object value = this.configData;
        for (String k : keys) {
            if (value instanceof Map) {
                value = value.get(k);
                continue;
            }
            if (value instanceof List && k.matches("\\d+")) {
                int index = Integer.parseInt(k);
                List list = (List)value;
                if (index >= 0 && index < list.size()) {
                    value = list.get(index);
                    continue;
                }
                return null;
            }
            return null;
        }
        return value;
    }

    public ArrayList<String> getStringList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object obj : (List)value) {
                if (!(obj instanceof String)) continue;
                list.add((String)obj);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public ArrayList<Integer> getIntList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(((Number)obj).intValue());
            }
            return list;
        }
        return new ArrayList<Integer>();
    }

    public ArrayList<Double> getDoubleList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(((Number)obj).doubleValue());
            }
            return list;
        }
        return new ArrayList<Double>();
    }

    public ArrayList<Float> getFloatList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(Float.valueOf(((Number)obj).floatValue()));
            }
            return list;
        }
        return new ArrayList<Float>();
    }

    public ArrayList<JsonConfiguration> getJsonList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<JsonConfiguration> list = new ArrayList<JsonConfiguration>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Map)) continue;
                list.add(new JsonConfiguration(new Gson().toJson(obj)));
            }
            return list;
        }
        return new ArrayList<JsonConfiguration>();
    }

    public ArrayList<Object> getList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            return new ArrayList<Object>((List)value);
        }
        return new ArrayList<Object>();
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public JsonConfiguration getJsonConfiguration(String key) {
        Object value = this.get(key);
        if (value instanceof Map) {
            return new JsonConfiguration(new Gson().toJson(value));
        }
        return null;
    }

    public void set(String key, Object value) {
        this.configData.put(key, value);
    }

    public void save() throws IOException {
        try (FileWriter writer = new FileWriter(this.filePath.toFile());){
            this.gson.toJson(this.configData, (Appendable)writer);
        }
    }

    public String toString() {
        return this.gson.toJson(this.configData);
    }

    public boolean equals(Object obj) {
        return obj.toString().equals(this.toString());
    }

    public boolean equalsCaseIgnoreCase(Object obj) {
        if (obj.toString() != null) {
            return obj.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }
}

