/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.plugin.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.byteflux.libby.Library;
import net.byteflux.libby.LibraryManager;
import org.cneko.ctlib.common.network.PingTest;

public class LibrariesLoader {
    public static LibraryManager manager;
    public static Map<String, Boolean> isLoad;

    public static void setManager(LibraryManager manager) {
        LibrariesLoader.manager = manager;
        LibrariesLoader.manager.addMavenCentral();
        String netUrl = "http://mirrors.163.com/maven/repository/maven-public/";
        if (PingTest.simplePing(netUrl) <= 500.0) {
            LibrariesLoader.addRepository(netUrl);
        }
    }

    public static void addRepository(String url) {
        manager.addRepository(url);
    }

    public static void load(String groupId, String artifactId, String version) {
        String longName = groupId + artifactId;
        if (!isLoad.containsKey(longName) || !isLoad.get(longName).booleanValue()) {
            LibrariesLoader.loadLib(groupId, artifactId, version);
            isLoad.put(longName, true);
        }
    }

    private static void loadLib(String groupId, String artifactId, String version) {
        if (manager == null) {
            throw new IllegalStateException("LibraryManager is not initialized");
        }
        Library library = Library.builder().groupId(groupId).artifactId(artifactId).version(version).build();
        manager.loadLibrary(library);
    }

    static {
        isLoad = new ConcurrentHashMap<String, Boolean>();
    }
}

