/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MemoryFileSystem {
    private final Map<String, byte[]> files = new HashMap<String, byte[]>();

    public Map<String, byte[]> getFiles() {
        return this.files;
    }

    public void addFile(String filename, byte[] content) {
        this.files.put(filename, content);
    }

    public void writeFile(String path, InputStream inputStream, byte[] buffer, int bytesRead) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        this.files.put(path, outputStream.toByteArray());
    }

    public byte[] readFile(String path) {
        return this.files.get(path);
    }

    public String readFile(String path, @Nullable String charset) throws IOException {
        byte[] content = this.readFile(path);
        if (content == null) {
            return null;
        }
        return new String(content, charset != null ? charset : "UTF-8");
    }

    public boolean exists(String path) {
        return this.files.containsKey(path);
    }

    public MemoryFileSystem readDirectory(String subdirectoryPath) throws IOException {
        if (subdirectoryPath == null) {
            throw new IllegalArgumentException("Subdirectory path cannot be null.");
        }
        if (subdirectoryPath.isEmpty()) {
            subdirectoryPath = "";
        }
        MemoryFileSystem subdirectoryFileSystem = new MemoryFileSystem();
        for (Map.Entry<String, byte[]> entry : this.files.entrySet()) {
            String filePath = entry.getKey();
            if (!filePath.startsWith(subdirectoryPath)) continue;
            int pathLength = subdirectoryPath.length();
            String filename = filePath.substring(pathLength);
            subdirectoryFileSystem.files.put(filename, entry.getValue());
        }
        return subdirectoryFileSystem;
    }
}

