/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cneko.ctlib.common.file.Configure;
import org.cneko.ctlib.common.file.YamlConfiguration;
import org.cneko.ctlib.common.util.base.FileUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class JsonConfiguration
implements Configure {
    private String original;
    private Map<String, Object> configData;
    private Gson gson;
    private Path filePath;

    public JsonConfiguration(Path filePath) throws IOException {
        this.filePath = filePath;
        this.gson = new Gson();
        this.configData = this.loadConfigData(filePath);
        this.original = FileUtil.readFileWithException(filePath.toString());
    }

    public JsonConfiguration(String jsonString) {
        this.gson = new Gson();
        this.configData = jsonString == null ? new HashMap<String, Object>() : (Map)this.gson.fromJson(jsonString, new TypeToken<Map<String, Object>>(){}.getType());
        this.original = jsonString;
    }

    private Map<String, Object> loadConfigData(Path filePath) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(filePath.toFile());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                return map;
            }
        }
        return new HashMap<String, Object>();
    }

    @Override
    public String getString(String key) {
        try {
            Object value = this.get(key);
            return value instanceof String ? (String)value : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getInt(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).intValue() : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public double getDouble(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).doubleValue() : 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public float getFloat(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Number ? ((Number)value).floatValue() : 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public boolean getBoolean(String key) {
        try {
            Object value = this.get(key);
            return value instanceof Boolean ? (Boolean)value : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            Object value = this.get(key);
            return value instanceof Boolean ? (Boolean)value : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public Object get(String key) {
        try {
            Object value = this.getValue(this.configData, key);
            if (value != null) {
                return value;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getValue(Object object, String key) {
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        return null;
    }

    private String getParentKey(String key) {
        int lastIndex = key.lastIndexOf(".");
        return lastIndex != -1 ? key.substring(0, lastIndex) : null;
    }

    private String getLastKey(String key) {
        int lastIndex = key.lastIndexOf(".");
        return lastIndex != -1 ? key.substring(lastIndex + 1) : key;
    }

    @Override
    public boolean isSet(String path) {
        return this.get(path) != null;
    }

    public ArrayList<String> getStringList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object obj : (List)value) {
                if (!(obj instanceof String)) continue;
                list.add((String)obj);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    @Override
    public ArrayList<Integer> getIntList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(((Number)obj).intValue());
            }
            return list;
        }
        return new ArrayList<Integer>();
    }

    @Override
    public ArrayList<Double> getDoubleList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(((Number)obj).doubleValue());
            }
            return list;
        }
        return new ArrayList<Double>();
    }

    @Override
    public ArrayList<Float> getFloatList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Number)) continue;
                list.add(Float.valueOf(((Number)obj).floatValue()));
            }
            return list;
        }
        return new ArrayList<Float>();
    }

    public ArrayList<JsonConfiguration> getJsonList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            ArrayList<JsonConfiguration> list = new ArrayList<JsonConfiguration>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Map)) continue;
                list.add(new JsonConfiguration(new Gson().toJson(obj)));
            }
            return list;
        }
        return new ArrayList<JsonConfiguration>();
    }

    @Override
    public ArrayList<Object> getList(String key) {
        Object value = this.get(key);
        if (value instanceof List) {
            return new ArrayList<Object>((List)value);
        }
        return new ArrayList<Object>();
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public ArrayList<JsonConfiguration> toJsonList() {
        ArrayList<JsonConfiguration> jsonList = new ArrayList<JsonConfiguration>();
        JsonElement element = (JsonElement)new Gson().fromJson(this.toString(), JsonElement.class);
        if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                jsonList.add(new JsonConfiguration(jsonObject.toString()));
            }
        }
        return jsonList;
    }

    public JsonConfiguration getJsonConfiguration(String key) {
        Object value = this.get(key);
        if (value instanceof Map) {
            return new JsonConfiguration(new Gson().toJson(value));
        }
        return null;
    }

    @Override
    public void set(String key, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof JsonConfiguration) {
                ArrayList<String> jsonStringList = new ArrayList<String>();
                for (Object item : list) {
                    jsonStringList.add(this.gson.toJson(item));
                }
                this.configData.put(key, jsonStringList);
            } else {
                this.configData.put(key, value);
            }
        } else {
            this.configData.put(key, value);
        }
    }

    @Override
    public void save() throws IOException {
        try (FileWriter writer = new FileWriter(this.filePath.toFile());){
            this.gson.toJson(this.configData, (Appendable)writer);
        }
    }

    public String getOriginal() {
        return this.original;
    }

    @Override
    public String toString() {
        return this.gson.toJson(this.configData);
    }

    @Override
    public boolean equals(Object obj) {
        return obj.toString().equals(this.toString());
    }

    @Override
    public boolean equalsCaseIgnoreCase(Object obj) {
        if (obj.toString() != null) {
            return obj.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }

    public YamlConfiguration toYaml() {
        Map map = (Map)this.gson.fromJson(this.original, new TypeToken<Map<String, Object>>(){}.getType());
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        return YamlConfiguration.of(yaml.dump(map));
    }

    public static JsonConfiguration fromFile(Path filePath) throws IOException {
        return new JsonConfiguration(filePath);
    }

    public static JsonConfiguration fromFile(File file) throws IOException {
        return new JsonConfiguration(file.toPath());
    }

    public static JsonConfiguration of(String jsonString) {
        return new JsonConfiguration(jsonString);
    }
}

