/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cneko.ctlib.common.file.Configure;
import org.cneko.ctlib.common.file.YamlConfiguration;
import org.cneko.ctlib.common.util.base.FileUtil;
import org.jetbrains.annotations.ApiStatus;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class JsonConfiguration
implements Configure {
    private final String original;
    private final JsonObject jsonObject;
    private Path filePath;

    public JsonConfiguration(String jsonString) {
        this.original = jsonString;
        Gson gson = new Gson();
        this.jsonObject = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
    }

    public JsonConfiguration(JsonObject jsonObject) {
        this.original = jsonObject.toString();
        this.jsonObject = jsonObject;
    }

    public JsonConfiguration(File file) throws IOException {
        this(file.toPath());
    }

    public JsonConfiguration(Path filePath) throws IOException {
        this(FileUtil.readFileWithException(filePath.toString()));
        this.filePath = filePath;
    }

    public JsonElement get(String path) {
        return this.jsonObject.get(path);
    }

    public JsonPrimitive getJsonPrimitive(String path) {
        JsonElement element = this.get(path);
        if (element != null && element.isJsonPrimitive()) {
            return element.getAsJsonPrimitive();
        }
        return new JsonPrimitive("");
    }

    public JsonArray getJsonArray(String path) {
        JsonElement element = this.get(path);
        if (element != null && element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        return new JsonArray();
    }

    @Override
    public void set(String path, Object value) {
        if (value instanceof JsonConfiguration) {
            this.jsonObject.add(path, (JsonElement)((JsonConfiguration)value).jsonObject);
            return;
        }
        if (value instanceof JsonElement) {
            this.jsonObject.add(path, (JsonElement)value);
            return;
        }
        if (value instanceof String) {
            this.jsonObject.addProperty(path, (String)value);
            return;
        }
        if (value instanceof Number) {
            this.jsonObject.addProperty(path, (Number)value);
            return;
        }
        if (value instanceof Boolean) {
            this.jsonObject.addProperty(path, (Boolean)value);
            return;
        }
        if (value instanceof Character) {
            this.jsonObject.addProperty(path, (Character)value);
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            JsonArray jsonArray = new JsonArray();
            if (list.isEmpty()) {
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof JsonConfiguration) {
                for (Object o : list) {
                    jsonArray.add((JsonElement)((JsonConfiguration)o).jsonObject);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof JsonElement) {
                for (Object o : list) {
                    jsonArray.add((JsonElement)o);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof String) {
                for (Object o : list) {
                    jsonArray.add((String)o);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof Number) {
                for (Object o : list) {
                    jsonArray.add((Number)o);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof Boolean) {
                for (Object o : list) {
                    jsonArray.add((Boolean)o);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
            if (list.get(0) instanceof Character) {
                for (Object o : list) {
                    jsonArray.add((Character)o);
                }
                this.jsonObject.add(path, (JsonElement)jsonArray);
                return;
            }
        }
        this.jsonObject.addProperty(path, value.toString());
    }

    public void save(Path filePath) {
        if (filePath != null) {
            FileUtil.overwriteFile(filePath, this.jsonObject.toString());
        }
    }

    @Override
    public void save() {
        this.save(this.filePath);
    }

    @Override
    public String getString(String path) {
        try {
            return this.getJsonPrimitive(path).getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public List<String> getStringList(String path) {
        JsonArray array = this.getJsonArray(path);
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement e : array) {
            if (!e.isJsonPrimitive()) continue;
            list.add(e.getAsJsonPrimitive().getAsString());
        }
        return list;
    }

    @Override
    public float getFloat(String path) {
        try {
            return this.getJsonPrimitive(path).getAsFloat();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public double getDouble(String path) {
        try {
            return this.getJsonPrimitive(path).getAsDouble();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public int getInt(String path) {
        try {
            return this.getJsonPrimitive(path).getAsInt();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean getBoolean(String path) {
        try {
            return this.getJsonPrimitive(path).getAsBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean getBoolean(String path, boolean defValue) {
        try {
            return this.getJsonPrimitive(path).getAsBoolean();
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public JsonConfiguration getJsonConfiguration(String path) {
        try {
            return new JsonConfiguration(this.getJsonPrimitive(path).getAsJsonObject());
        }
        catch (Exception e) {
            return new JsonConfiguration("{}");
        }
    }

    @Override
    public boolean contains(String key) {
        return this.jsonObject.has(key);
    }

    @Override
    public List<Integer> getIntList(String path) {
        JsonArray array = this.getJsonArray(path);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonElement e : array) {
            if (!e.isJsonPrimitive()) continue;
            list.add(e.getAsJsonPrimitive().getAsInt());
        }
        return list;
    }

    @Override
    public List<Double> getDoubleList(String path) {
        JsonArray array = this.getJsonArray(path);
        ArrayList<Double> list = new ArrayList<Double>();
        for (JsonElement e : array) {
            if (!e.isJsonPrimitive()) continue;
            list.add(e.getAsJsonPrimitive().getAsDouble());
        }
        return list;
    }

    @Override
    public List<Float> getFloatList(String path) {
        JsonArray array = this.getJsonArray(path);
        ArrayList<Float> list = new ArrayList<Float>();
        for (JsonElement e : array) {
            if (!e.isJsonPrimitive()) continue;
            list.add(Float.valueOf(e.getAsJsonPrimitive().getAsFloat()));
        }
        return list;
    }

    public List<JsonConfiguration> getJsonList(String path) {
        JsonArray array = this.getJsonArray(path);
        return array.asList().stream().map(e -> new JsonConfiguration(e.getAsJsonObject())).collect(Collectors.toList());
    }

    @Override
    public List<Object> getList(String path) {
        JsonArray array = this.getJsonArray(path);
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement e : array) {
            if (!e.isJsonPrimitive()) continue;
            list.add(e.getAsJsonPrimitive().getAsJsonObject());
        }
        return list;
    }

    public String getOriginal() {
        return this.original;
    }

    @Override
    public boolean equalsCaseIgnoreCase(Object obj) {
        if (obj instanceof JsonConfiguration) {
            JsonConfiguration other = (JsonConfiguration)obj;
            return this.jsonObject.equals((Object)other.jsonObject);
        }
        return obj.toString().equalsIgnoreCase(this.jsonObject.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JsonConfiguration) {
            JsonConfiguration other = (JsonConfiguration)obj;
            return this.jsonObject.equals((Object)other.jsonObject);
        }
        return obj.toString().equals(this.jsonObject.toString());
    }

    public List<JsonConfiguration> toJsonList() {
        if (this.jsonObject.isJsonArray()) {
            return this.jsonObject.getAsJsonArray().asList().stream().map(e -> new JsonConfiguration(e.getAsJsonObject())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public JsonObject toGson() {
        return this.jsonObject;
    }

    @ApiStatus.Experimental
    public YamlConfiguration toYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : this.jsonObject.entrySet()) {
            map.put((String)entry.getKey(), this.convertJsonElementToJavaType((JsonElement)entry.getValue()));
        }
        return new YamlConfiguration(yaml.dump(map));
    }

    private Object convertJsonElementToJavaType(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
        } else {
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ArrayList<Object> list = new ArrayList<Object>();
                for (JsonElement item : array) {
                    list.add(this.convertJsonElementToJavaType(item));
                }
                return list;
            }
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry entry : object.entrySet()) {
                    map.put((String)entry.getKey(), this.convertJsonElementToJavaType((JsonElement)entry.getValue()));
                }
                return map;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.jsonObject.toString();
    }

    public static JsonConfiguration of(String jsonString) {
        return new JsonConfiguration(jsonString);
    }

    public static JsonConfiguration fromFile(File file) throws IOException {
        return new JsonConfiguration(file);
    }

    public static JsonConfiguration fromFile(Path filePath) throws IOException {
        return new JsonConfiguration(filePath);
    }
}

