/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.util.base;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class FileUtil {
    public static String readFile(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String readFileWithException(String path) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Error reading file: " + e.getMessage());
            return "";
        }
    }

    public static void overwriteFile(Path path, String content) {
        try {
            Files.write(path, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to write to file: " + path);
            e.printStackTrace();
        }
    }

    public static class FileChecker {
        public static FileTypes checkFileType(String content) {
            if (FileChecker.isJson(content)) {
                return FileTypes.JSON;
            }
            if (FileChecker.isYaml(content)) {
                return FileTypes.YAML;
            }
            return FileTypes.UNKNOWN;
        }

        public static FileTypes checkFileType(File file) {
            FileTypes fileTypes;
            block8: {
                BufferedReader reader = Files.newBufferedReader(file.toPath());
                try {
                    String content = FileChecker.readContent(reader);
                    fileTypes = FileChecker.checkFileType(content);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return FileTypes.UNKNOWN;
                    }
                }
                ((Reader)reader).close();
            }
            return fileTypes;
        }

        public static FileTypes checkFileType(Path file) {
            FileTypes fileTypes;
            block8: {
                BufferedReader reader = Files.newBufferedReader(file);
                try {
                    String content = FileChecker.readContent(reader);
                    fileTypes = FileChecker.checkFileType(content);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return FileTypes.UNKNOWN;
                    }
                }
                ((Reader)reader).close();
            }
            return fileTypes;
        }

        private static String readContent(Reader reader) throws IOException {
            int data;
            StringBuilder sb = new StringBuilder();
            while ((data = reader.read()) != -1) {
                sb.append((char)data);
            }
            return sb.toString();
        }

        public static boolean isJson(String content) {
            try {
                new Gson().fromJson(content, Object.class);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public static boolean isYaml(String content) {
            try {
                new Yaml().load(content);
                return true;
            }
            catch (YAMLException e) {
                return false;
            }
        }

        public static enum FileTypes {
            JSON,
            YAML,
            UNKNOWN;

        }
    }
}

