/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.event;

import com.crystalneko.ctlibPublic.File.JsonConfiguration;
import com.crystalneko.ctlibPublic.File.YamlConfiguration;
import com.crystalneko.ctlibPublic.inGame.chatPrefix;
import com.crystalneko.ctlibPublic.network.httpGet;
import com.crystalneko.ctlibPublic.sql.sqlite;
import com.crystalneko.tonekofabric.libs.base;
import com.crystalneko.tonekofabric.libs.lp;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class playerChat {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    public static void init() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> playerChat.onChatMessage((class_1657)sender, message.method_46291()), executorService);
            return false;
        });
    }

    public static void onChatMessage(class_1657 player, class_2561 message) {
        if (message != null) {
            MinecraftServer server = player.method_5682();
            String worldName = base.getWorldName(player.method_37908());
            String playerName = base.getPlayerName(player);
            class_2561 newMessage = playerChat.modifyMessage(message, worldName, playerName, false, server);
            playerChat.sendMsg(newMessage, server);
        }
    }

    private static void sendMsg(class_2561 message, MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> player.method_43496(message));
    }

    private static class_2561 modifyMessage(class_2561 message, String worldName, String playerName, Boolean isAI, MinecraftServer server) {
        lp.build();
        base.start(worldName);
        if (message == null || message.getString().isEmpty()) {
            return null;
        }
        String[] nekoList = sqlite.readAllValueInAColumn((String)(worldName + "Nekos"), (String)"neko");
        Object stringMessage = message.getString();
        if (sqlite.checkValueExists((String)(worldName + "Nekos"), (String)"neko", (String)playerName)) {
            String strAliases;
            String owner = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"owner", (String)"neko", (String)playerName);
            String ownerText = base.translatable("chat.neko.owner").getString();
            if (owner != null && !owner.isEmpty()) {
                stringMessage = ((String)stringMessage).replaceAll(owner, ownerText);
            }
            if ((strAliases = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"aliases", (String)"neko", (String)playerName)) != null) {
                String[] aliases;
                for (String value : aliases = strAliases.split(",")) {
                    stringMessage = ((String)stringMessage).replaceAll(value, ownerText);
                }
            }
            String nya = base.translatable("chat.neko.nya").getString();
            stringMessage = playerChat.replaceChar((String)stringMessage, ',', nya, 0.4);
            stringMessage = playerChat.replaceChar((String)stringMessage, '\uff0c', nya, 0.4);
            stringMessage = (String)stringMessage + nya;
            stringMessage = playerChat.replaceBlocks((String)stringMessage, playerName, worldName);
            String libPublicPrefix = chatPrefix.getAllPublicPrefixValues();
            String libPrefix = chatPrefix.getPrivatePrefix((String)playerName);
            if (libPrefix.equalsIgnoreCase("[\u00a7a\u65e0\u524d\u7f00\u00a7f\u00a7r]")) {
                libPrefix = "";
            }
            String prefix = libPrefix + libPublicPrefix;
            stringMessage = prefix + playerName + "\u00a7b >> \u00a77" + (String)stringMessage;
            if (!isAI.booleanValue()) {
                YamlConfiguration config = null;
                try {
                    config = new YamlConfiguration(Path.of("ctlib/toneko/config.yml", new String[0]));
                }
                catch (IOException e) {
                    System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:" + e.getMessage());
                }
                if (config != null && config.getBoolean("AI.enable")) {
                    for (String str : nekoList) {
                        String AIMsg;
                        if (!((String)stringMessage).contains(str)) continue;
                        String type = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"type", (String)"neko", (String)str);
                        if (!base.getOwner(str, worldName).equalsIgnoreCase(playerName) || type == null || !type.equalsIgnoreCase("AI")) continue;
                        String language = config.getString("language");
                        String API = config.getString("AI.API");
                        String prompt = config.getString("AI.prompt");
                        prompt = prompt.replaceAll("%name%", str);
                        prompt = prompt.replaceAll("%owner%", owner);
                        String rightMsg = ((String)stringMessage).replaceAll("&", "and");
                        String url = API.replaceAll("%text%", rightMsg);
                        url = url.replaceAll("%prompt%", prompt);
                        JsonConfiguration response = null;
                        try {
                            response = httpGet.getJson((String)url, null);
                        }
                        catch (IOException e) {
                            System.out.println("\u65e0\u6cd5\u83b7\u53d6json:" + e.getMessage());
                        }
                        if (response == null || (AIMsg = language.equalsIgnoreCase("zh_cn") ? response.getString("response") : response.getString("source_response")) == null) continue;
                        class_2561 textAIMsg = playerChat.modifyMessage(class_2561.method_30163((String)AIMsg), worldName, playerName, true, server);
                        playerChat.sendMsg(textAIMsg, server);
                    }
                }
            }
        } else {
            stringMessage = playerName + "\u00a7b >> \u00a77" + (String)stringMessage;
        }
        return class_2561.method_30163((String)stringMessage);
    }

    public static String replaceChar(String str, char oldChar, String newStr, double probability) {
        StringBuilder builder = new StringBuilder(str);
        Random random = new Random();
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != oldChar || !(random.nextDouble() <= probability)) continue;
            builder.replace(i, i + 1, newStr);
            i += newStr.length() - 1;
        }
        return builder.toString();
    }

    private static String replaceBlocks(String message, String neko2, String worldName) {
        if (sqlite.checkValueExists((String)(worldName + "Nekos"), (String)"neko", (String)neko2)) {
            String block = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"block", (String)"neko", (String)neko2);
            String replace = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"replace", (String)"neko", (String)neko2);
            String method = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"method", (String)"neko", (String)neko2);
            if (block != null) {
                String[] blocks = block.split(",");
                String[] replaces = replace.split(",");
                Object[] methods = method.split(",");
                int length = blocks.length;
                int allIndex = Arrays.binarySearch(methods, "all");
                if (allIndex >= 0 && message.contains(blocks[allIndex])) {
                    message = message.replaceAll(message, replaces[allIndex]);
                } else {
                    for (int i = 0; i < length; ++i) {
                        message = message.replaceAll(blocks[i], replaces[i]);
                    }
                }
            }
        }
        return message;
    }
}

