/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.libs;

import com.crystalneko.ctlibPublic.File.YamlConfiguration;
import com.crystalneko.ctlibPublic.sql.sqlite;
import com.crystalneko.tonekofabric.ToNekoFabric;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class base {
    public static YamlConfiguration config;
    public static String dataFolder;
    public static String language;
    public static YamlConfiguration languageConfig;
    public static Boolean clientLanguage;

    public base() {
        this.create();
        Path configFile = Path.of("ctlib/toneko/config.yml", new String[0]);
        if (!Files.exists(configFile, new LinkOption[0])) {
            this.copyResource("/config.yml", dataFolder, "config.yml");
        }
        try {
            config = new YamlConfiguration(configFile);
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:" + e.getMessage());
        }
        this.loadLanguageFile();
        clientLanguage = config.getBoolean("client-language");
    }

    public static void start(String worldName) {
        if (!ToNekoFabric.started.booleanValue()) {
            if (!sqlite.isTableExists((String)(worldName + "Nekos"))) {
                sqlite.createTable((String)(worldName + "Nekos"));
            }
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"neko");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"owner");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"block");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"method");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"replace");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"xp");
            sqlite.addColumn((String)(worldName + "Nekos"), (String)"type");
            if (!sqlite.isTableExists((String)(worldName + "NekoEnt"))) {
                sqlite.createTable((String)(worldName + "NekoEnt"));
            }
            sqlite.addColumn((String)(worldName + "NekoEnt"), (String)"uuid");
            sqlite.addColumn((String)(worldName + "NekoEnt"), (String)"name");
        }
    }

    public static Boolean createFileInDirectory(String directoryPath, String fileName) throws IOException {
        String filePath = directoryPath + fileName;
        Path directory = Paths.get(directoryPath, new String[0]);
        Files.createDirectories(directory, new FileAttribute[0]);
        Path file = Paths.get(filePath, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
            return true;
        }
        return false;
    }

    public static String isNekoHasOwner(String neko2, String worldName) {
        if (sqlite.checkValueExists((String)(worldName + "Nekos"), (String)"neko", (String)neko2)) {
            return sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"owner", (String)"neko", (String)neko2);
        }
        return null;
    }

    public static void setPlayerNeko(String neko2, String worldName, String owner) {
        sqlite.saveData((String)(worldName + "Nekos"), (String)"neko", (String)neko2);
        sqlite.saveDataWhere((String)(worldName + "Nekos"), (String)"xp", (String)"neko", (String)neko2, (String)"0");
        sqlite.saveDataWhere((String)(worldName + "Nekos"), (String)"owner", (String)"neko", (String)neko2, (String)owner);
    }

    public static String getOwner(String neko2, String worldName) {
        String owner = sqlite.getColumnValue((String)(worldName + "Nekos"), (String)"owner", (String)"neko", (String)neko2);
        if (owner != null) {
            return owner;
        }
        return base.translatable("base.null.owner").getString();
    }

    public static String getPlayerName(class_1657 player) {
        String playerName = player.method_5477().getString();
        playerName = playerName.replace("literal{", "").replace("}", "");
        return playerName;
    }

    public static class_2561 getStringLanguage(String key, String[] replace) {
        return class_2561.method_43469((String)key, (Object[])replace);
    }

    public static String getWorldName(class_1937 world) {
        String name = world.toString();
        name = name.replace("[", "");
        name = name.replace("]", "");
        name = name.replace("ServerLevel", "");
        return name;
    }

    public void create() {
        Path zh_cnPath;
        Path path = Path.of("ctlib/toneko", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println("can not create path:" + e.getMessage());
            }
        }
        if (!Files.exists(Path.of("ctlib/toneko/language", new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Path.of("ctlib/toneko/language", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\u5939:" + e.getMessage());
            }
        }
        if (Files.exists(zh_cnPath = Path.of("ctlib/toneko/language/zh_cn.yml", new String[0]), new LinkOption[0])) {
            try {
                Files.delete(zh_cnPath);
            }
            catch (IOException e) {
                System.out.println("\u65e0\u6cd5\u5220\u9664\u8bed\u8a00\u6587\u4ef6:" + e.getMessage());
            }
        }
        Path en_usPath = Path.of("ctlib/toneko/language/en_us.yml", new String[0]);
        if (Files.exists(zh_cnPath, new LinkOption[0])) {
            try {
                Files.delete(en_usPath);
            }
            catch (IOException e) {
                System.out.println("\u65e0\u6cd5\u5220\u9664\u8bed\u8a00\u6587\u4ef6:" + e.getMessage());
            }
        }
    }

    public void copyResource(String resourcePath, String dataFolder, String fileName) {
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in == null) {
                System.out.println("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90\u6587\u4ef6");
                return;
            }
            Path pluginDataFolder = Path.of(dataFolder, new String[0]);
            Path outputPath = pluginDataFolder.resolve(fileName);
            Files.copy(in, outputPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("\u8d44\u6e90\u6587\u4ef6\u590d\u5236\u6210\u529f");
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u590d\u5236\u8d44\u6e90\u6587\u4ef6" + e);
        }
    }

    private void loadLanguageFile() {
        language = config.getString("language");
        Path languageFile = Path.of("ctlib/toneko/language/" + language + ".yml", new String[0]);
        if (!Files.exists(languageFile, new LinkOption[0])) {
            this.copyResource("/language/" + language + ".yml", dataFolder + "/language", language + ".yml");
        }
        try {
            languageConfig = new YamlConfiguration(languageFile);
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6:" + e.getMessage());
        }
    }

    public static String getMessage(String key) {
        return languageConfig.getString(key);
    }

    public static class_2561 translatable(String key) {
        if (clientLanguage.booleanValue()) {
            return class_2561.method_43471((String)key);
        }
        String text = base.getMessage(key);
        class_2561 text1 = class_2561.method_30163((String)text);
        return text1;
    }

    public static class_2561 translatable(String key, String[] replace) {
        if (clientLanguage.booleanValue()) {
            return class_2561.method_43469((String)key, (Object[])replace);
        }
        String text = base.getMessage(key);
        text = text.replace("%d", replace[0]);
        if (replace.length == 2) {
            text = text.replace("%c", replace[1]);
        }
        class_2561 text1 = class_2561.method_30163((String)text);
        return text1;
    }

    static {
        dataFolder = "ctlib/toneko";
    }
}

