/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.event;

import com.crystalneko.tonekocommon.Stats;
import com.crystalneko.tonekocommon.util.ThreadFactories;
import com.crystalneko.tonekofabric.api.Query;
import com.crystalneko.tonekofabric.libs.base;
import com.crystalneko.tonekofabric.libs.lp;
import com.crystalneko.tonekofabric.util.TextUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import org.cneko.ctlib.common.file.JsonConfiguration;
import org.cneko.ctlib.common.file.YamlConfiguration;
import org.cneko.ctlib.common.network.HttpGet;
import org.cneko.ctlib.common.util.ChatPrefix;
import org.cneko.ctlib.common.util.LocalDataBase;

public class PlayerChat {
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactories.ChatThreadFactory());

    public static void init() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> PlayerChat.onChatMessage((class_1657)sender, message.method_46291()), executorService);
            return false;
        });
    }

    public static void onChatMessage(class_1657 player, class_2561 message) {
        if (message != null) {
            MinecraftServer server = player.method_5682();
            String worldName = TextUtil.getWorldName(player.method_37908());
            String playerName = TextUtil.getPlayerName(player);
            String newMessage = PlayerChat.modifyMessage(message, worldName, playerName);
            PlayerChat.sendMsg(class_2561.method_30163((String)newMessage), server);
            PlayerChat.AIMsg(newMessage, worldName, playerName, server);
            Stats.meowInChat(TextUtil.getPlayerName(player), newMessage);
        }
    }

    private static void sendMsg(class_2561 message, MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> player.method_43496(message));
    }

    private static String modifyMessage(class_2561 message, String worldName, String playerName) {
        lp.build();
        base.start(worldName);
        if (message == null || message.getString().isEmpty()) {
            return null;
        }
        Object stringMessage = message.getString();
        if (LocalDataBase.Connections.sqlite.checkValueExists(worldName + "Nekos", "neko", playerName)) {
            String strAliases;
            String owner = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "owner", "neko", playerName);
            String ownerText = class_2561.method_43471((String)"chat.neko.owner").getString();
            if (owner != null && !owner.isEmpty()) {
                stringMessage = ((String)stringMessage).replaceAll(owner, ownerText);
            }
            if ((strAliases = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "aliases", "neko", playerName)) != null) {
                String[] aliases;
                for (String value : aliases = strAliases.split(",")) {
                    stringMessage = ((String)stringMessage).replaceAll(value, ownerText);
                }
            }
            String nya = class_2561.method_43471((String)"chat.neko.nya").getString();
            stringMessage = PlayerChat.replaceChar((String)stringMessage, ',', nya, 0.4);
            stringMessage = PlayerChat.replaceChar((String)stringMessage, '\uff0c', nya, 0.4);
            stringMessage = (String)stringMessage + nya;
            stringMessage = PlayerChat.replaceBlocks((String)stringMessage, playerName, worldName);
            String libPublicPrefix = ChatPrefix.getAllPublicPrefixValues();
            String libPrefix = ChatPrefix.getPrivatePrefix((String)playerName);
            if (libPrefix.equalsIgnoreCase("[\u00a7a\u65e0\u524d\u7f00\u00a7f\u00a7r]")) {
                libPrefix = "";
            }
            String prefix = libPrefix + libPublicPrefix;
            stringMessage = prefix + "\u00a7e" + playerName + "\u00a76 >> \u00a7f" + (String)stringMessage;
        } else {
            stringMessage = "\u00a7e" + playerName + "\u00a76 >> \u00a7f" + (String)stringMessage;
        }
        return stringMessage;
    }

    private static void AIMsg(String stringMessage, String worldName, String playerName, MinecraftServer server) {
        YamlConfiguration config = null;
        try {
            config = new YamlConfiguration(Path.of("ctlib/toneko/config.yml", new String[0]));
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:" + e.getMessage());
        }
        if (config != null && config.getBoolean("AI.enable")) {
            String[] nekoList;
            for (String str : nekoList = LocalDataBase.Connections.sqlite.readAllValueInAColumn(worldName + "Nekos", "neko")) {
                String AIMsg;
                if (!stringMessage.contains(str)) continue;
                String type = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "type", "neko", str);
                if (!Query.getOwner(str, worldName).equalsIgnoreCase(playerName) || type == null || !type.equalsIgnoreCase("AI")) continue;
                String owner = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "owner", "neko", playerName);
                String API = config.getString("AI.API");
                String prompt = config.getString("AI.prompt");
                prompt = prompt.replaceAll("%name%", str);
                prompt = prompt.replaceAll("%owner%", owner);
                String rightMsg = stringMessage.replaceAll("&", "and");
                String url = API.replaceAll("%text%", rightMsg);
                url = url.replaceAll("%prompt%", prompt);
                JsonConfiguration response = null;
                try {
                    response = HttpGet.SimpleHttpGet.getJson((String)url, null);
                }
                catch (IOException e) {
                    System.out.println("\u65e0\u6cd5\u83b7\u53d6json:" + e.getMessage());
                }
                if (response == null || (AIMsg = response.getString("response")) == null) continue;
                String textAIMsg = PlayerChat.modifyMessage(class_2561.method_30163((String)AIMsg), worldName, playerName);
                PlayerChat.sendMsg(class_2561.method_30163((String)textAIMsg), server);
            }
        }
    }

    public static String replaceChar(String str, char oldChar, String newStr, double probability) {
        StringBuilder builder = new StringBuilder(str);
        Random random = new Random();
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != oldChar || !(random.nextDouble() <= probability)) continue;
            builder.replace(i, i + 1, newStr);
            i += newStr.length() - 1;
        }
        return builder.toString();
    }

    private static String replaceBlocks(String message, String neko, String worldName) {
        if (LocalDataBase.Connections.sqlite.checkValueExists(worldName + "Nekos", "neko", neko)) {
            String block = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "block", "neko", neko);
            String replace = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "replace", "neko", neko);
            String method = LocalDataBase.Connections.sqlite.getColumnValue(worldName + "Nekos", "method", "neko", neko);
            if (block != null) {
                String[] blocks = block.split(",");
                String[] replaces = replace.split(",");
                Object[] methods = method.split(",");
                int length = blocks.length;
                int allIndex = Arrays.binarySearch(methods, "all");
                if (allIndex >= 0 && message.contains(blocks[allIndex])) {
                    message = message.replaceAll(message, replaces[allIndex]);
                } else {
                    for (int i = 0; i < length; ++i) {
                        message = message.replaceAll(blocks[i], replaces[i]);
                    }
                }
            }
        }
        return message;
    }
}

