/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko.event;

import com.crystalneko.toneko.ToNeko;
import com.crystalneko.toneko.utils.ConfigFileUtils;
import com.crystalneko.tonekocommon.Stats;
import java.io.File;
import java.util.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.cneko.ctlib.common.util.ChatPrefix;

public class PlayerEventListenerBase
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player;
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        if (data.getString((player = event.getPlayer()).getName() + ".owner") != null) {
            ChatPrefix.addPrivatePrefix((String)player.getName(), (String)ToNeko.getMessage("other.neko"));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player;
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        if (data.getString((player = event.getPlayer()).getName() + ".owner") != null) {
            ChatPrefix.removePrivatePrefix((String)player.getName(), (String)ToNeko.getMessage("other.neko"));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player killer;
        ItemStack itemStack;
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        Player player = event.getEntity();
        if (player.getKiller() instanceof Player && (itemStack = (killer = player.getKiller()).getInventory().getItemInMainHand()) != null) {
            String nbtValue;
            ItemMeta itemMeta = itemStack.getItemMeta();
            NamespacedKey key = new NamespacedKey((Plugin)ToNeko.pluginInstance, "neko");
            if (itemMeta.getPersistentDataContainer().has(key, PersistentDataType.STRING) && (nbtValue = (String)itemMeta.getPersistentDataContainer().get(key, PersistentDataType.STRING)).equals("true") && data.getString(player.getName() + ".owner") != null) {
                String deathMessage = "\u732b\u5a18 " + player.getName() + " \u88ab " + killer.getName() + " \u00a7f\u6485\u6b7b\u4e86\uff01";
                event.setDeathMessage(deathMessage);
                if (killer.getName().equals(data.getString(player.getName() + ".owner"))) {
                    Random random = new Random();
                    int randomNumber = random.nextInt(7) + 3;
                    ConfigFileUtils.createNewKey(player.getName() + ".xp", 0, data, dataFile);
                    int xpValue = data.getInt(player.getName() + ".xp") - randomNumber;
                    ConfigFileUtils.setValue(player.getName() + ".xp", xpValue, dataFile);
                    player.sendMessage(ToNeko.getMessage("death.sub-xp", new String[]{killer.getName(), String.valueOf(randomNumber)}));
                    killer.sendMessage(ToNeko.getMessage("death.sub-xp", new String[]{player.getName(), String.valueOf(randomNumber)}));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getDamager() instanceof Player) {
                int nbtValue2;
                File dataFile = new File("plugins/toNeko/nekos.yml");
                YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
                Player killer = (Player)event.getDamager();
                ItemStack itemStack = killer.getInventory().getItemInMainHand();
                if (itemStack == null || !itemStack.getType().isItem()) {
                    return;
                }
                ItemMeta itemMeta = itemStack.getItemMeta();
                NamespacedKey key = new NamespacedKey((Plugin)ToNeko.pluginInstance, "neko");
                NamespacedKey key2 = new NamespacedKey((Plugin)ToNeko.pluginInstance, "nekolevel");
                if (itemMeta != null && itemMeta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
                    String nbtValue = (String)itemMeta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                    if (nbtValue.equalsIgnoreCase("true") && data.getString(player.getName() + ".owner") != null) {
                        PotionEffectType effectType = PotionEffectType.WEAKNESS;
                        int duration = 200;
                        int amplifier = 0;
                        this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                        if (killer.getName().equals(data.getString(player.getName() + ".owner"))) {
                            Random random = new Random();
                            int randomNumber = random.nextInt(6) - 2;
                            ConfigFileUtils.createNewKey(player.getName() + ".xp", 0, data, dataFile);
                            int xpValue = data.getInt(player.getName() + ".xp") + randomNumber;
                            ConfigFileUtils.setValue(player.getName() + ".xp", xpValue, dataFile);
                            player.sendMessage(ToNeko.getMessage("attack.add-xp", new String[]{killer.getName(), String.valueOf(randomNumber)}));
                            killer.sendMessage(ToNeko.getMessage("attack.add-xp", new String[]{player.getName(), String.valueOf(randomNumber)}));
                        }
                        player.getWorld().playSound(player.getLocation(), "toneko.neko.stick", 1.0f, 1.0f);
                        killer.getWorld().playSound(player.getLocation(), "toneko.neko.stick", 1.0f, 1.0f);
                        this.addStatistic(player.getName(), killer.getName());
                    }
                } else if (itemMeta != null && itemMeta.getPersistentDataContainer().has(key2, PersistentDataType.INTEGER) && (nbtValue2 = ((Integer)itemMeta.getPersistentDataContainer().get(key2, PersistentDataType.INTEGER)).intValue()) == 2) {
                    PotionEffectType effectType = PotionEffectType.WEAKNESS;
                    PotionEffectType effectType2 = PotionEffectType.BLINDNESS;
                    PotionEffectType effectType3 = PotionEffectType.SLOW;
                    PotionEffectType effectType4 = PotionEffectType.DARKNESS;
                    int duration = 1000;
                    int amplifier = 3;
                    this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                    this.givePlayerPotionEffect(player, effectType2, duration, amplifier);
                    this.givePlayerPotionEffect(player, effectType3, duration, amplifier);
                    this.givePlayerPotionEffect(player, effectType4, duration, amplifier);
                    if (killer.getName().equals(data.getString(player.getName() + ".owner"))) {
                        Random random = new Random();
                        int randomNumber = random.nextInt(14) + 2;
                        ConfigFileUtils.createNewKey(player.getName() + ".xp", 0, data, dataFile);
                        int xpValue = data.getInt(player.getName() + ".xp") + randomNumber + 10;
                        ConfigFileUtils.setValue(player.getName() + ".xp", xpValue, dataFile);
                        player.sendMessage(ToNeko.getMessage("attack.add-xp", new String[]{killer.getName(), String.valueOf(randomNumber)}));
                        killer.sendMessage(ToNeko.getMessage("attack.add-xp", new String[]{player.getName(), String.valueOf(randomNumber)}));
                        this.addStatistic(player.getName(), killer.getName());
                    }
                    player.getWorld().playSound(player.getLocation(), "toneko.neko.stick.level2", 1.0f, 1.0f);
                    killer.getWorld().playSound(player.getLocation(), "toneko.neko.stick.level2", 1.0f, 1.0f);
                }
            }
        }
    }

    private void givePlayerPotionEffect(Player player, PotionEffectType type, int duration, int amplifier) {
        PotionEffect effect = new PotionEffect(type, duration, amplifier);
        player.addPotionEffect(effect);
    }

    public void addStatistic(String neko, String player) {
        Stats.stick(player, neko);
    }
}

