/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekocommon.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ThreadFactories {

    public static class ChatThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger count = new AtomicInteger(1);

        public ChatThreadFactory() {
            this.namePrefix = "ToNeko Chat Thread";
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-pool-" + this.count.getAndIncrement());
            return t;
        }
    }

    public static class StatsThreadFactory
    implements ThreadFactory {
        private final String namePrefix;
        private final AtomicInteger count = new AtomicInteger(1);

        public StatsThreadFactory() {
            this.namePrefix = "ToNeko Stats Thread";
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(r, this.namePrefix + "-pool-" + this.count.getAndIncrement());
            return t;
        }
    }
}

