/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko.chat;

import com.crystalneko.toneko.ToNeko;
import com.crystalneko.tonekocommon.Stats;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.cneko.ctlib.common.file.JsonConfiguration;
import org.cneko.ctlib.common.network.HttpGet;
import org.cneko.ctlib.common.util.ChatPrefix;
import org.cneko.ctlib.common.util.LocalDataBase;

public class NekoChatListener
implements Listener {
    public void bootstrap() {
        try {
            Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
            ToNeko.logger.info(ToNeko.getMessage("folia.use.chatEvent"));
            Bukkit.getServer().getPluginManager().registerEvent(AsyncChatEvent.class, (Listener)this, EventPriority.NORMAL, new EventExecutor(){

                public void execute(Listener listener, Event event2) {
                    NekoChatListener.this.onPlayerChatPaper((AsyncChatEvent)event2);
                }
            }, (Plugin)ToNeko.pluginInstance);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getServer().getPluginManager().registerEvent(AsyncPlayerChatEvent.class, (Listener)this, EventPriority.NORMAL, new EventExecutor(){

                public void execute(Listener listener, Event event2) {
                    NekoChatListener.this.onPlayerChat((AsyncPlayerChatEvent)event2);
                }
            }, (Plugin)ToNeko.pluginInstance);
        }
    }

    public void sendMessage(String playerName, String prefix, String formattedMessage) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(prefix + "\u00a7e" + playerName + " \u00a76>> \u00a7f" + formattedMessage);
        }
    }

    public void sendMessageToPlayers(String player, String prefix, String message, boolean isAI) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        if (data.getString(player + ".owner") != null) {
            String owner = data.getString(player + ".owner");
            ArrayList<String> aliases = new ArrayList<String>();
            if (data.getList(player + ".aliases") != null) {
                aliases = data.getStringList(player + ".aliases");
            } else {
                aliases.add("Crystal_Neko");
            }
            String catMessage = this.catChatMessage(message, owner, aliases);
            message = catMessage = this.replaceBlocks(catMessage, player);
        }
        this.sendMessage(player, prefix, message);
        if (!isAI && ToNeko.config.getBoolean("AI.enable")) {
            ArrayList<String> nekoList = new ArrayList<String>();
            for (String key : data.getKeys(false)) {
                if (!data.contains(key + ".type") || !data.getString(key + ".type").equals("AI")) continue;
                nekoList.add(key);
            }
            for (String str : nekoList) {
                String AIMsg;
                String owner;
                if (!message.contains(str) || (owner = data.getString(str + ".owner")) == null || !owner.equalsIgnoreCase(player)) continue;
                String language = ToNeko.config.getString("language");
                String API = ToNeko.config.getString("AI.API");
                String prompt = ToNeko.config.getString("AI.prompt");
                prompt = prompt.replaceAll("%name%", str);
                prompt = prompt.replaceAll("%owner%", owner);
                String rightMsg = message.replaceAll("&", "and");
                String url = API.replaceAll("%text%", rightMsg);
                url = url.replaceAll("%prompt%", prompt);
                JsonConfiguration response = null;
                try {
                    response = HttpGet.SimpleHttpGet.getJson((String)url, null);
                }
                catch (IOException e) {
                    System.out.println("\u65e0\u6cd5\u83b7\u53d6json:" + e.getMessage());
                }
                if (response == null || (AIMsg = language.equalsIgnoreCase("zh_cn") ? response.getString("response") : response.getString("source_response")) == null) continue;
                this.sendMessageToPlayers(str, "[" + ToNeko.getMessage("chat.neko.prefix") + "]", AIMsg, true);
            }
        }
    }

    public void onPlayerChat(AsyncPlayerChatEvent event2) {
        String privatePrefix;
        Player player = event2.getPlayer();
        String message = event2.getMessage();
        String publicPrefix = ChatPrefix.getAllPublicPrefixValues();
        Object prefix = publicPrefix + (privatePrefix = ChatPrefix.getPrivatePrefix((String)player.getName()));
        if (((String)prefix).equalsIgnoreCase("[\u00a7a\u65e0\u524d\u7f00\u00a7f\u00a7r]")) {
            prefix = "";
        }
        this.sendMessageToPlayers(player.getName(), (String)prefix, message, false);
        Stats.meowInChat(player.getName(), message);
    }

    public void onPlayerChatPaper(AsyncChatEvent event2) {
        event2.setCancelled(true);
        Player player = event2.getPlayer();
        String message = (String)MiniMessage.miniMessage().serialize(event2.message());
        String publicPrefix = ChatPrefix.getAllPublicPrefixValues();
        String privatePrefix = ChatPrefix.getPrivatePrefix((String)player.getName());
        Object prefix = publicPrefix + privatePrefix;
        if (((String)prefix).equalsIgnoreCase("[\u00a7a\u65e0\u524d\u7f00\u00a7f\u00a7r]")) {
            prefix = "";
        }
        this.sendMessageToPlayers(player.getName(), (String)prefix, message, false);
        Stats.meowInChat(player.getName(), message);
    }

    public String catChatMessage(String message, String owner, List<String> aliases) {
        message = ((String)message).replaceAll(owner, ToNeko.getMessage("other.owner"));
        for (String value : aliases) {
            message = ((String)message).replaceAll(value, ToNeko.getMessage("other.owner"));
        }
        message = this.replaceChar((String)message, ',', ToNeko.getMessage("other.nya"), 0.4);
        if (!((String)(message = this.replaceChar((String)message, '\uff0c', ToNeko.getMessage("other.nya"), 0.4))).endsWith(ToNeko.getMessage("other.nya"))) {
            message = ((String)message).endsWith(".") ? this.replaceChar((String)message, '.', ToNeko.getMessage("other.nya"), 1.0) : (String)message + ToNeko.getMessage("other.nya");
        }
        return message;
    }

    public String replaceChar(String str, char oldChar, String newStr, double probability) {
        StringBuilder builder = new StringBuilder(str);
        Random random = new Random();
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != oldChar || !(random.nextDouble() <= probability)) continue;
            builder.replace(i, i + 1, newStr);
            i += newStr.length() - 1;
        }
        return builder.toString();
    }

    private String replaceBlocks(String message, String neko) {
        String block = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "block", "neko", neko);
        String replace = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "replace", "neko", neko);
        String method = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "method", "neko", neko);
        if (block != null) {
            String[] blocks = block.split(",");
            String[] replaces = replace.split(",");
            Object[] methods = method.split(",");
            int length = blocks.length;
            int allIndex = Arrays.binarySearch(methods, "all");
            if (allIndex >= 0 && message.contains(blocks[allIndex])) {
                message = message.replaceAll(message, replaces[allIndex]);
            } else {
                for (int i = 0; i < length; ++i) {
                    message = message.replaceAll(blocks[i], replaces[i]);
                }
            }
        }
        return message;
    }
}

