/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.csnktools.CTTool;

import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class CTScoreboard
implements Listener {
    private final JavaPlugin plugin;
    private final ScoreboardManager scoreboardManager;
    private final Scoreboard scoreboard;
    private Objective objective;

    public CTScoreboard(JavaPlugin plugin) {
        this.plugin = plugin;
        this.scoreboardManager = Bukkit.getScoreboardManager();
        this.scoreboard = this.scoreboardManager.getNewScoreboard();
    }

    public void createScoreboard(Player player) {
        this.objective = this.scoreboard.getObjective("ctscoreboard") != null ? this.scoreboard.getObjective("ctscoreboard") : this.scoreboard.registerNewObjective("ctscoreboard", "dummy");
        String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Scoreboard.title"));
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        List lines = this.plugin.getConfig().getStringList("Scoreboard.line");
        int score = lines.size();
        for (String line : lines) {
            String replacedLine = this.replaceVariables(player, line);
            if (this.scoreboard.getTeam(replacedLine) == null) {
                Team team = this.scoreboard.registerNewTeam(this.getUniqueTeamName(score));
                team.addEntry(replacedLine);
                team.setPrefix(replacedLine);
            }
            this.objective.getScore(replacedLine).setScore(score);
            --score;
        }
        player.setScoreboard(this.scoreboard);
        this.startScoreboardUpdateTask(player);
    }

    public void updateScoreboard(Player player) {
        this.objective.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Scoreboard.title")));
        List lines = this.plugin.getConfig().getStringList("Scoreboard.line");
        int score = lines.size();
        for (String line : lines) {
            String replacedLine = this.replaceVariables(player, line);
            Team team = this.scoreboard.getTeam(replacedLine);
            if (team == null) continue;
            team.setPrefix(replacedLine);
            this.objective.getScore(replacedLine).setScore(score);
            --score;
        }
    }

    public void removeScoreboard(Player player) {
        player.setScoreboard(this.scoreboardManager.getMainScoreboard());
    }

    public void startScoreboardUpdateTask(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline()) {
                    CTScoreboard.this.updateScoreboard(player);
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.plugin.getConfig().getInt("Scoreboard.update") * 20L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.createScoreboard(event.getPlayer());
    }

    private String replaceVariables(Player player, String line) {
        String replacedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)replacedLine);
    }

    private String getUniqueTeamName(int score) {
        return "line" + score + "_" + UUID.randomUUID().toString();
    }
}

