/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.csnktools.CTTool;

import com.crystalneko.csnktools.csnktools.CSNKTools;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class CTScoreboard
implements Listener {
    private List<String> ScoreboardLine;
    private String ScoreboardTitle;
    private int taskID;
    FileConfiguration config = ((CSNKTools)JavaPlugin.getPlugin(CSNKTools.class)).getConfig();
    private final JavaPlugin plugin;

    public CTScoreboard(FileConfiguration config, JavaPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
        this.loadConfig();
    }

    public List<String> loadConfig() {
        FileConfiguration config = ((CSNKTools)JavaPlugin.getPlugin(CSNKTools.class)).getConfig();
        List ScoreboardLine = config.getStringList("Scoreboard.line");
        this.ScoreboardTitle = config.getString("Scoreboard.title");
        return ScoreboardLine;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent event) {
        this.ScoreboardLine = this.loadConfig();
        Player player = event.getPlayer();
        this.ScoreboardLine = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), this.ScoreboardLine);
        this.ScoreboardTitle = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)this.ScoreboardTitle);
        this.setScoreboard(player, this.ScoreboardLine);
        this.startTask();
    }

    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private void setScoreboard(Player player, List<String> scoreboardLine1) {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
        Objective objective = scoreboard.getObjective("CTScoreboard");
        if (objective == null) {
            objective = scoreboard.registerNewObjective("CTScoreboard", "dummy", this.ScoreboardTitle);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        } else {
            objective.unregister();
            objective = scoreboard.registerNewObjective("CTScoreboard", "dummy", this.ScoreboardTitle);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        int score = scoreboardLine1.size();
        for (String line : this.ScoreboardLine) {
            objective.getScore(line).setScore(score--);
        }
        player.setScoreboard(scoreboard);
    }

    public void startTask() {
        int updateInterval = this.config.getInt("Scoreboard.update");
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            this.loadConfig();
            Bukkit.getServer().getOnlinePlayers().forEach(player -> this.setScoreboard((Player)player, this.ScoreboardLine));
        }, (long)updateInterval, (long)updateInterval);
    }
}

