/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.csnktools;

import com.crystalneko.csnktools.csnktools.CTTool.CTScoreboard;
import com.crystalneko.csnktools.csnktools.CTTool.Music;
import com.crystalneko.csnktools.csnktools.CTTool.loginmsg;
import com.crystalneko.csnktools.csnktools.CTcommand.csnktools;
import com.crystalneko.csnktools.csnktools.CTcommand.csnktoolsTabCompleter;
import com.crystalneko.csnktools.csnktools.Metrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class CSNKTools
extends JavaPlugin
implements Listener {
    private String pluginVersion;
    private File configFile;
    private FileConfiguration config;
    private loginmsg loginMsgListener;
    private CTScoreboard CTScoreboardListener;
    private Music musicListener;
    private FileConfiguration languageConfig;
    private String language;

    public void onEnable() {
        int pluginId = 19702;
        Metrics metrics = new Metrics(this, pluginId);
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = this.getConfig();
        if (!this.configFile.exists()) {
            this.saveResource("Config.yml", false);
        }
        String configFileName = "config.yml";
        File configFile = new File(this.getDataFolder(), configFileName);
        File oldConfigFile = new File(this.getDataFolder(), "Config.yml");
        if (oldConfigFile.exists() && !configFile.exists()) {
            oldConfigFile.renameTo(configFile);
        }
        this.createConfigFile();
        this.createLanguageFiles();
        this.pluginVersion = this.getDescription().getVersion();
        this.savePluginVersionToConfig();
        this.loadLanguageFile();
        String enableplugin = this.getMessage("Console.enable");
        Bukkit.getConsoleSender().sendMessage(enableplugin);
        this.checkUpdates();
        this.readconfig();
    }

    public void readconfig() {
        Boolean papienable = this.isPluginLoaded("PlaceholderAPI");
        if (!papienable.booleanValue()) {
            String NOPAPI = this.getMessage("Error.NOPAPI");
            Bukkit.getConsoleSender().sendMessage(NOPAPI);
        }
        Boolean nbapienable = this.isPluginLoaded("NoteBlockAPI");
        if (!nbapienable.booleanValue()) {
            String NONBAPI = this.getMessage("Error.NONBAPI");
            Bukkit.getConsoleSender().sendMessage(NONBAPI);
        }
        this.getCommand("csnktools").setExecutor((CommandExecutor)new csnktools(this, nbapienable));
        this.getCommand("csnktools").setTabCompleter((TabCompleter)new csnktoolsTabCompleter());
        String loadingplugin = this.getMessage("Console.loading");
        Bukkit.getConsoleSender().sendMessage(loadingplugin);
        this.getCommand("csnktools").setExecutor((CommandExecutor)new csnktools(this, nbapienable));
        if (this.getConfig().getBoolean("player.join.Enable")) {
            this.loginMsgListener = new loginmsg();
            this.getServer().getPluginManager().registerEvents((Listener)this.loginMsgListener, (Plugin)this);
            this.loginMsgListener.loadConfig(papienable);
        }
        if (this.getConfig().getBoolean("Scoreboard.Enable")) {
            this.CTScoreboardListener = new CTScoreboard(this, papienable);
            this.getServer().getPluginManager().registerEvents((Listener)this.CTScoreboardListener, (Plugin)this);
            this.CTScoreboardListener.lloadConfig();
        }
    }

    private void createLanguageFiles() {
        String[] languageFiles = new String[]{"zh-cn.yml", "en-eu.yml", "more.yml"};
        File languageFolder = new File(this.getDataFolder(), "language");
        if (!languageFolder.exists()) {
            languageFolder.mkdirs();
        }
        for (String fileName : languageFiles) {
            File languageFile = new File(languageFolder, fileName);
            if (languageFile.exists()) continue;
            this.saveResource("language/" + fileName, false);
        }
    }

    private void loadLanguageFile() {
        this.language = this.getConfig().getString("language");
        File languageFile = new File(this.getDataFolder(), "language/" + this.language + ".yml");
        if (!languageFile.exists()) {
            this.saveResource("language/" + this.language + ".yml", false);
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
        String versionPlaceholder = "%version%";
        String translatedVersion = this.languageConfig.getString("plugin-version");
        if (translatedVersion != null) {
            translatedVersion = translatedVersion.replace(versionPlaceholder, this.pluginVersion);
            this.languageConfig.set("plugin-version", (Object)translatedVersion);
        }
    }

    public String getMessage(String key) {
        return this.languageConfig.getString(key);
    }

    public void checkUpdates() {
        String remoteUrl = "https://w.csk.asia/res/version.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    String checkupdate_update = this.getMessage("System.check-update.update");
                    this.getLogger().info(checkupdate_update);
                } else {
                    String checkupdate_isupdate = this.getMessage("System.check-update.is-update");
                    this.getLogger().info(checkupdate_isupdate);
                }
            } else {
                String checkupdate_warning = this.getMessage("System.check-update.warning");
                this.getLogger().warning(checkupdate_warning + responseCode);
            }
            connection.disconnect();
        }
        catch (IOException e) {
            String checkupdate_warning2 = this.getMessage("System.check-update.warning2");
            this.getLogger().warning(checkupdate_warning2 + e.getMessage());
        }
    }

    public void checkUpdates2(Player player) {
        String remoteUrl = "https://w.csk.asia/res/version.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    String checkupdate_update = this.getMessage("System.check-update.update");
                    if (checkupdate_update != null) {
                        player.sendMessage(checkupdate_update);
                    }
                } else {
                    String checkupdate_isupdate = this.getMessage("System.check-update.is-update");
                    if (checkupdate_isupdate != null) {
                        player.sendMessage(checkupdate_isupdate);
                    }
                }
            } else {
                String checkupdate_warning = this.getMessage("System.check-update.warning");
                player.sendMessage(checkupdate_warning + responseCode);
            }
            connection.disconnect();
        }
        catch (IOException e) {
            String checkupdate_warning2 = this.getMessage("System.check-update.warning2");
            player.sendMessage(checkupdate_warning2 + e.getMessage());
        }
    }

    public void createConfigFile() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = this.getConfig();
        if (!this.configFile.exists()) {
            this.saveResource("Config.yml", false);
        }
        String configFileName = "config.yml";
        File configFile = new File(this.getDataFolder(), configFileName);
        File oldConfigFile = new File(this.getDataFolder(), "Config.yml");
        if (oldConfigFile.exists() && !configFile.exists()) {
            oldConfigFile.renameTo(configFile);
        }
    }

    private void savePluginVersionToConfig() {
        FileConfiguration config = this.getConfig();
        config.set("plugin-version", (Object)this.pluginVersion);
        this.saveConfig();
    }

    private boolean isPluginLoaded(String pluginName) {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        Plugin targetPlugin = pluginManager.getPlugin(pluginName);
        return targetPlugin != null && targetPlugin.isEnabled();
    }

    public void onDisable() {
        File tempfolder = new File("plugins/CSNKTools/temp");
        CSNKTools.deleteFolder(tempfolder);
        this.getMessage("Console.enable");
        Bukkit.getConsoleSender().sendMessage(new String[0]);
    }

    public static void deleteFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                CSNKTools.deleteFolder(file);
            }
        }
        folder.delete();
    }
}

