/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.csnktools.website;

import com.crystalneko.csnktools.csnktools.CSNKTools;
import com.crystalneko.csnktools.csnktools.CTTool.mysqlandemail;
import com.crystalneko.csnktools.csnktools.CTTool.mysqlandemail2;
import java.io.IOException;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;

public class LoginServlet
extends HttpServlet {
    private CSNKTools plugin;
    private mysqlandemail mysqlAndemail;
    private mysqlandemail2 mysqlAndemail2;
    private String table_name;

    public LoginServlet(CSNKTools plugin, mysqlandemail mysqlAndemail, mysqlandemail2 mysqlAndemail2) {
        this.plugin = plugin;
        this.mysqlAndemail = mysqlAndemail;
        this.mysqlAndemail2 = mysqlAndemail2;
        this.table_name = plugin.getConfig().getString("website.user_table");
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.equals("/*")) {
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            boolean authenticated = this.authenticate(username, password);
            System.out.println(authenticated);
            if (authenticated) {
                String permission = this.mysqlAndemail2.read_table_data("permission", this.table_name);
                if ("admin".equals(permission)) {
                    response.sendRedirect("../admin.html");
                } else {
                    response.sendRedirect("../user.html");
                }
            } else {
                response.sendRedirect("../login.html");
            }
        } else if (pathInfo.equals("/register")) {
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String email = request.getParameter("email");
            this.sendEmailVerification(username, email);
            response.sendRedirect("/plugins/CSNKTools/website/login.html");
        }
    }

    private boolean authenticate(String username, String password) {
        String passwordHash = this.mysqlAndemail2.read_password_and_salt(username, this.table_name);
        Boolean hashpassword = this.comparePassword(password, passwordHash);
        return hashpassword;
    }

    private void sendEmailVerification(String username, String email) {
        Random random = new Random();
        int authcode = random.nextInt(100000);
        String auth_code = String.valueOf(authcode);
        String subject = this.plugin.getConfig().getString("website.email.register_subject");
        String[] placeholders = new String[]{"<username />", "<auth_code />"};
        String[] values = new String[]{username, auth_code};
        this.mysqlAndemail.setsendmessage(email, subject, placeholders, values, "plugins/CSNKTools/email/authcode.html");
    }

    private boolean comparePassword(String inputPassword, String storedHash) {
        String[] parts;
        if (storedHash.startsWith("$SHA$") && (parts = storedHash.split("\\$")).length == 4) {
            String salt = parts[2];
            String computedHash = this.computeHash(inputPassword, salt);
            return storedHash.equals(computedHash);
        }
        return false;
    }

    private String computeHash(String password, String salt) {
        return "$SHA$" + salt + "$" + DigestUtils.sha256Hex(DigestUtils.sha256Hex(password) + salt);
    }
}

