/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.CTTool;

import com.crystalneko.csnktools.CSNKTools;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class CTScoreboard
implements Listener {
    private List<String> scoreboardLine;
    private String scoreboardTitle;
    private int taskID;
    private JavaPlugin plugin;
    private Boolean papiEnable;

    public CTScoreboard(JavaPlugin plugin, Boolean papienable) {
        this.plugin = plugin;
        this.lloadConfig();
        this.papiEnable = papienable;
    }

    public List<String> lloadConfig() {
        List scoreboardLine;
        FileConfiguration config = this.plugin.getConfig();
        this.scoreboardTitle = config.getString("Scoreboard.title");
        this.scoreboardLine = scoreboardLine = config.getStringList("Scoreboard.line");
        return scoreboardLine;
    }

    private List<String> parsePlaceholders(List<String> scoreboardLines, Player player) {
        ArrayList<String> parsedLines = new ArrayList<String>();
        for (String line : scoreboardLines) {
            String parsedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
            parsedLines.add(parsedLine);
        }
        return parsedLines;
    }

    public String getMessage(String key) {
        CSNKTools csnkTools = (CSNKTools)this.plugin;
        return csnkTools.getMessage(key);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.scoreboardLine = this.lloadConfig();
        if (this.scoreboardLine == null) {
            String noline = this.getMessage("Scoreboard.noline");
            Bukkit.getConsoleSender().sendMessage(noline);
        } else {
            this.scoreboardLine = PlaceholderAPI.setPlaceholders((Player)player, this.scoreboardLine);
        }
        this.scoreboardTitle = PlaceholderAPI.setPlaceholders((Player)player, (String)this.scoreboardTitle);
        this.setScoreboard(player, this.scoreboardLine);
        this.startTask();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    private void setScoreboard(Player player, List<String> scoreboardLine1) {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = scoreboardManager.getNewScoreboard();
        Objective objective = scoreboard.getObjective("CTScoreboard");
        if (objective == null) {
            objective = scoreboard.registerNewObjective("CTScoreboard", "dummy", this.scoreboardTitle);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        } else {
            objective.unregister();
            objective = scoreboard.registerNewObjective("CTScoreboard", "dummy", this.scoreboardTitle);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        if (this.papiEnable.booleanValue()) {
            List<String> parsedLines = this.parsePlaceholders(scoreboardLine1, player);
            int score = parsedLines.size();
            for (String line : parsedLines) {
                objective.getScore(line).setScore(score--);
            }
        } else {
            int score = scoreboardLine1.size();
            for (String line : scoreboardLine1) {
                objective.getScore(line).setScore(score--);
            }
        }
        player.setScoreboard(scoreboard);
    }

    public void startTask() {
        FileConfiguration config = this.plugin.getConfig();
        int updateInterval = config.getInt("Scoreboard.update");
        Bukkit.getScheduler().cancelTask(this.taskID);
        List<String> scoreboardLine = this.lloadConfig();
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> Bukkit.getServer().getOnlinePlayers().forEach(player -> this.setScoreboard((Player)player, scoreboardLine)), (long)updateInterval, (long)updateInterval);
    }

    private boolean isPluginLoaded(String pluginName) {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        Plugin targetPlugin = pluginManager.getPlugin(pluginName);
        return targetPlugin != null && targetPlugin.isEnabled();
    }
}

