/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.CTTool;

import com.crystalneko.csnktools.CSNKTools;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;

public class sqlite {
    public Connection sqliteconnection;
    private CSNKTools plugin;

    public sqlite(CSNKTools plugin) {
        this.plugin = plugin;
        try {
            this.createConnection();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public Connection createConnection() throws SQLException {
        if (this.sqliteconnection != null && !this.sqliteconnection.isClosed()) {
            return this.sqliteconnection;
        }
        String sqlitePath = this.plugin.getConfig().getString("sqlite.path");
        File sqliteFile = new File(sqlitePath);
        if (!sqliteFile.exists()) {
            try {
                if (sqliteFile.createNewFile()) {
                    Bukkit.getConsoleSender().sendMessage(this.plugin.getMessage("Plugins.sqlite.createFile"));
                } else {
                    Bukkit.getConsoleSender().sendMessage(this.plugin.getMessage("Plugins.sqlite.FailedCreateFile"));
                }
            }
            catch (IOException e) {
                Bukkit.getConsoleSender().sendMessage(this.plugin.getMessage("Plugins.sqlite.UnableCreateFile"));
                e.printStackTrace();
            }
        }
        String sqliteConnectionUrl = "jdbc:sqlite:" + sqlitePath;
        this.sqliteconnection = DriverManager.getConnection(sqliteConnectionUrl);
        return this.sqliteconnection;
    }

    public void saveData(String tableName, String columnName, String data) {
        if (!this.isTableExists(tableName)) {
            this.createTable(tableName);
        }
        this.addColumn(tableName, columnName);
        String query = "INSERT INTO " + tableName + " (" + columnName + ") VALUES (?)";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.setString(1, data);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void saveDataWhere(String tableName, String columnName, String whereName, String whereValue, String columnValue) {
        if (!this.isTableExists(tableName)) {
            this.createTable(tableName);
        }
        String query = "UPDATE " + tableName + " SET " + columnName + " = ? WHERE " + whereName + " = ?";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.setString(1, columnValue);
            statement.setString(2, whereValue);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void saveColumn(String tableName, String columnName, Object columnValue) {
        if (!this.isTableExists(tableName)) {
            this.createTable(tableName);
        }
        this.addColumn(tableName, columnName);
        String query = "INSERT OR IGNORE INTO " + tableName + "(" + columnName + ") VALUES (?)";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.setObject(1, columnValue);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isTableExists(String tableName) {
        try {
            DatabaseMetaData metaData = this.sqliteconnection.getMetaData();
            ResultSet resultSet = metaData.getTables(null, null, tableName, null);
            return resultSet.next();
        }
        catch (SQLException e) {
            System.out.println(e);
            return false;
        }
    }

    public void createTable(String tableName) {
        String query = "CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY AUTOINCREMENT)";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    private boolean isColumnExists(String tableName, String columnName) {
        try {
            DatabaseMetaData metaData = this.sqliteconnection.getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, tableName, columnName);
            return resultSet.next();
        }
        catch (SQLException e) {
            System.out.println(e);
            return false;
        }
    }

    public void addColumn(String tableName, String columnName) {
        if (this.checkColumnExists(tableName, columnName)) {
            return;
        }
        String query = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " TEXT";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public boolean checkColumnExists(String tableName, String columnName) {
        boolean bl;
        block8: {
            ResultSet resultSet = this.sqliteconnection.getMetaData().getColumns(null, null, tableName, columnName);
            try {
                bl = resultSet.next();
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.out.println(e);
                    return false;
                }
            }
            resultSet.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkValueExists(String tableName, String columnName, String value) {
        String query = "SELECT COUNT(*) FROM " + tableName + " WHERE " + columnName + " = ?";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.setString(1, value);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return false;
            int count = resultSet.getInt(1);
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnValue(String tableName, String columnName, String whereName, String whereValue) {
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + whereName + "=?";
        try (PreparedStatement statement = this.sqliteconnection.prepareStatement(query);){
            statement.setString(1, whereValue);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String string = resultSet.getString(columnName);
                return string;
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        return null;
    }
}

