/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.website;

import com.crystalneko.csnktools.CSNKTools;
import com.crystalneko.csnktools.CTTool.mysqlandemail;
import com.crystalneko.csnktools.CTTool.mysqlandemail2;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;

public class LoginServlet
extends HttpServlet {
    private CSNKTools plugin;
    private mysqlandemail mysqlAndemail;
    private mysqlandemail2 mysqlAndemail2;
    private String table_name;

    public LoginServlet(CSNKTools plugin, mysqlandemail mysqlAndemail, mysqlandemail2 mysqlAndemail2) {
        this.plugin = plugin;
        this.mysqlAndemail = mysqlAndemail;
        this.mysqlAndemail2 = mysqlAndemail2;
        this.table_name = plugin.getConfig().getString("website.user_table");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo.equals("/login")) {
            String password;
            String username = request.getParameter("username");
            boolean authenticated = this.authenticate(username, password = request.getParameter("password"));
            if (authenticated) {
                String permission = this.mysqlAndemail2.read_table_where_data("permission", this.table_name, "username", username);
                if ("admin".equals(permission)) {
                    response.sendRedirect("../admin.html");
                } else {
                    String ipAddress = request.getRemoteAddr();
                    long currentTimeStamp = System.currentTimeMillis();
                    this.mysqlAndemail2.set_table_data(this.table_name, "username", username, "logged", String.valueOf(currentTimeStamp));
                    String redirectUrl = "../user/user?username=" + username;
                    response.sendRedirect(redirectUrl);
                }
            } else {
                response.sendRedirect("../login.html");
            }
        } else if (pathInfo.equals("/register")) {
            String username = request.getParameter("username");
            String password = request.getParameter("password");
            String email = request.getParameter("email");
            this.createUser(username, password, email);
        }
    }

    private boolean authenticate(String username, String password) {
        String passwordHash = this.mysqlAndemail2.read_password_and_salt(username, this.table_name);
        Boolean hashpassword = this.comparePassword(password, passwordHash);
        return hashpassword;
    }

    private void sendEmailVerification(String username, String email) {
        Random random = new Random();
        int authcode = random.nextInt(100000);
        String auth_code = String.valueOf(authcode);
        String subject = this.plugin.getConfig().getString("website.email.register_subject");
        String[] placeholders = new String[]{"<username />", "<auth_code />"};
        String[] values = new String[]{username, auth_code};
        this.mysqlAndemail.setsendmessage(email, subject, placeholders, values, "plugins/CSNKTools/email/authcode.html");
    }

    private boolean comparePassword(String inputPassword, String storedHash) {
        String[] parts;
        if (storedHash.startsWith("$SHA$") && (parts = storedHash.split("\\$")).length == 4) {
            String salt = parts[2];
            String computedHash = this.computeHash(inputPassword, salt);
            return storedHash.equals(computedHash);
        }
        return false;
    }

    private String computeHash(String password, String salt) {
        return "$SHA$" + salt + "$" + DigestUtils.sha256Hex((String)(DigestUtils.sha256Hex((String)password) + salt));
    }

    private String computeHash2(String password) {
        UUID uuid = UUID.randomUUID();
        String salt = uuid.toString().replace("-", "");
        String hashedPassword = DigestUtils.sha256Hex((String)password);
        String saltedPassword = hashedPassword + salt;
        String combinedHash = DigestUtils.sha256Hex((String)saltedPassword);
        return "$SHA$" + salt + "$" + combinedHash;
    }

    private void createUser(String username, String password, String email) {
        String hashedPassword = this.computeHash2(password);
        String[] data = new String[]{username, hashedPassword, email, "user"};
        this.mysqlAndemail2.writetable(this.table_name, "username,password,email,permission", data);
    }
}

