/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools;

import com.crystalneko.csnktools.CTTool.CTScoreboard;
import com.crystalneko.csnktools.CTTool.HtmlPlaceholderConverter;
import com.crystalneko.csnktools.CTTool.loginmsg;
import com.crystalneko.csnktools.CTTool.mysqlandemail;
import com.crystalneko.csnktools.CTTool.mysqlandemail2;
import com.crystalneko.csnktools.CTTool.serverendisable;
import com.crystalneko.csnktools.CTTool.sqlite;
import com.crystalneko.csnktools.CTcommand.csnktools;
import com.crystalneko.csnktools.CTcommand.csnktoolsTabCompleter;
import com.crystalneko.csnktools.CTcommand.csnktoolsadmin;
import com.crystalneko.csnktools.CTcommand.download;
import com.crystalneko.csnktools.Metrics;
import com.crystalneko.csnktools.sql.PlayerJoinListener;
import com.crystalneko.csnktools.website.LoginServlet;
import com.crystalneko.csnktools.website.UserServlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.Servlet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public final class CSNKTools
extends JavaPlugin
implements Listener {
    private File configFile;
    private FileConfiguration config;
    private loginmsg loginMsgListener;
    private CTScoreboard CTScoreboardListener;
    private FileConfiguration languageConfig;
    private String language;
    private mysqlandemail mysqlAndemail;
    private mysqlandemail2 mysqlAndemail2;
    private serverendisable serverendisaBle;
    private HtmlPlaceholderConverter htmlPlaceholderConverter;
    private sqlite sqLite;
    private PlayerJoinListener playerJoinListener;

    public void onEnable() {
        int pluginId = 19702;
        Metrics metrics = new Metrics(this, pluginId);
        download.checkAndDownloadPlugin("ctLib", "https://w.csk.asia/plugins/ctLib.jar");
        this.copyresourceFiles();
        this.createConfigFile();
        this.loadLanguageFile();
        String enableplugin = this.getMessage("Console.enable");
        Bukkit.getConsoleSender().sendMessage(enableplugin);
        this.checkUpdates();
        CSNKTools.createNecessary();
        this.readconfig();
    }

    public void readconfig() {
        Boolean papienable = this.isPluginLoaded("PlaceholderAPI");
        if (!papienable.booleanValue()) {
            String NOPAPI = this.getMessage("Error.NOPAPI");
            Bukkit.getConsoleSender().sendMessage(NOPAPI);
        }
        Boolean nbapienable = this.isPluginLoaded("NoteBlockAPI");
        if (!nbapienable.booleanValue()) {
            String NONBAPI = this.getMessage("Error.NONBAPI");
            Bukkit.getConsoleSender().sendMessage(NONBAPI);
        }
        this.mysqlAndemail2 = new mysqlandemail2(this);
        this.htmlPlaceholderConverter = new HtmlPlaceholderConverter(this);
        this.mysqlAndemail = new mysqlandemail(this, this.htmlPlaceholderConverter);
        this.sqLite = new sqlite(this);
        this.playerJoinListener = new PlayerJoinListener(this.sqLite, this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.sqLite, this), (Plugin)this);
        this.getCommand("csnktools").setExecutor((CommandExecutor)new csnktools(this, nbapienable, this.mysqlAndemail, this.htmlPlaceholderConverter));
        this.getCommand("csnktoolsadmin").setExecutor((CommandExecutor)new csnktoolsadmin(this));
        this.getCommand("csnktools").setTabCompleter((TabCompleter)new csnktoolsTabCompleter());
        this.getCommand("csnktoolsadmin").setTabCompleter((TabCompleter)new csnktoolsTabCompleter());
        String loadingplugin = this.getMessage("Console.loading");
        Bukkit.getConsoleSender().sendMessage(loadingplugin);
        if (this.getConfig().getBoolean("mysql.Enable")) {
            this.mysqlAndemail2.loadConfig();
        }
        if (this.getConfig().getBoolean("smtp.Enable")) {
            this.mysqlAndemail.loadConfig();
            if (this.getConfig().getBoolean("serverendisable.enable")) {
                this.serverendisaBle = new serverendisable(this.mysqlAndemail, this, this.mysqlAndemail2, this.sqLite);
                this.serverendisaBle.serverenable();
            }
        }
        if (this.getConfig().getBoolean("website.Enable")) {
            String table_name = this.getConfig().getString("website.user_table");
            this.mysqlAndemail2.createColumn(table_name, "username", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "password", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "ip", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "regip", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "email", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "permission", "VARCHAR(255)");
            this.mysqlAndemail2.createColumn(table_name, "logged", "VARCHAR(255)");
            this.mysqlAndemail2.create_table(table_name, "username VARCHAR(255),password VARCHAR(255),ip VARCHAR(255),regip VARCHAR(255),email VARCHAR(255),permission VARCHAR(255),logged VARCHAR(255)");
            final LoginServlet loginServlet = new LoginServlet(this, this.mysqlAndemail, this.mysqlAndemail2);
            final UserServlet userServlet = new UserServlet(this.htmlPlaceholderConverter, this.mysqlAndemail2, this, this.sqLite);
            Thread jettyThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            int port = CSNKTools.this.getConfig().getInt("website.port");
                            Server server = new Server(port);
                            ServletContextHandler userservlet = new ServletContextHandler(1);
                            userservlet.setContextPath("/user");
                            userservlet.addServlet(new ServletHolder((Servlet)userServlet), "/*");
                            ServletContextHandler loginservlet = new ServletContextHandler(1);
                            loginservlet.setContextPath("/login");
                            loginservlet.addServlet(new ServletHolder((Servlet)loginServlet), "/*");
                            ResourceHandler resourceHandler = new ResourceHandler();
                            String resourceBase = System.getProperty("user.dir") + "/plugins/CSNKTools/website/";
                            resourceHandler.setResourceBase(resourceBase);
                            resourceHandler.setDirectoriesListed(CSNKTools.this.getConfig().getBoolean("website.dirlist"));
                            HandlerCollection handlers = new HandlerCollection();
                            handlers.setHandlers(new Handler[]{resourceHandler, loginservlet, userservlet});
                            server.setHandler((Handler)handlers);
                            server.start();
                            server.join();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            jettyThread.start();
        }
        if (this.getConfig().getBoolean("player.join.Enable")) {
            this.loginMsgListener = new loginmsg();
            this.getServer().getPluginManager().registerEvents((Listener)this.loginMsgListener, (Plugin)this);
            this.loginMsgListener.loadConfig(papienable);
        }
        if (this.getConfig().getBoolean("Scoreboard.Enable")) {
            this.CTScoreboardListener = new CTScoreboard(this, papienable);
            this.getServer().getPluginManager().registerEvents((Listener)this.CTScoreboardListener, (Plugin)this);
            this.CTScoreboardListener.lloadConfig();
        }
    }

    private void loadLanguageFile() {
        this.language = this.getConfig().getString("language");
        File languageFile = new File(this.getDataFolder(), "language/" + this.language + ".yml");
        if (!languageFile.exists()) {
            this.saveResource("language/" + this.language + ".yml", false);
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    public String getMessage(String key) {
        return this.languageConfig.getString(key);
    }

    public void checkUpdates() {
        String remoteUrl = "https://w.csk.asia/res/version/CSNKTools.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    String checkupdate_update = this.getMessage("System.check-update.update");
                    this.getLogger().info(checkupdate_update);
                } else {
                    String checkupdate_isupdate = this.getMessage("System.check-update.is-update");
                    this.getLogger().info(checkupdate_isupdate);
                }
            } else {
                String checkupdate_warning = this.getMessage("System.check-update.warning");
                this.getLogger().warning(checkupdate_warning + responseCode);
            }
            connection.disconnect();
        }
        catch (IOException e) {
            String checkupdate_warning2 = this.getMessage("System.check-update.warning2");
            this.getLogger().warning(checkupdate_warning2 + e.getMessage());
        }
    }

    public void checkUpdates2(Player player) {
        String remoteUrl = "https://w.csk.asia/res/version/CSNKTools.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    String checkupdate_update = this.getMessage("System.check-update.update");
                    if (checkupdate_update != null) {
                        player.sendMessage(checkupdate_update);
                    }
                } else {
                    String checkupdate_isupdate = this.getMessage("System.check-update.is-update");
                    if (checkupdate_isupdate != null) {
                        player.sendMessage(checkupdate_isupdate);
                    }
                }
            } else {
                String checkupdate_warning = this.getMessage("System.check-update.warning");
                player.sendMessage(checkupdate_warning + responseCode);
            }
            connection.disconnect();
        }
        catch (IOException e) {
            String checkupdate_warning2 = this.getMessage("System.check-update.warning2");
            player.sendMessage(checkupdate_warning2 + e.getMessage());
        }
    }

    public void createConfigFile() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = this.getConfig();
        if (!this.configFile.exists()) {
            this.saveResource("Config.yml", false);
        }
        String configFileName = "config.yml";
        File configFile = new File(this.getDataFolder(), configFileName);
        File oldConfigFile = new File(this.getDataFolder(), "Config.yml");
        if (oldConfigFile.exists() && !configFile.exists()) {
            oldConfigFile.renameTo(configFile);
        }
    }

    private boolean isPluginLoaded(String pluginName) {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        Plugin targetPlugin = pluginManager.getPlugin(pluginName);
        return targetPlugin != null && targetPlugin.isEnabled();
    }

    private void copyresourceFiles() {
        File targetFolder = new File(this.getDataFolder().getParentFile(), "CSNKTools");
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        this.checkAndSaveResource("email/serverdisable.html");
        this.checkAndSaveResource("email/serverenable.html");
        this.checkAndSaveResource("email/feedback.html");
        this.checkAndSaveResource("website/index.html");
        this.checkAndSaveResource("website/login.html");
        this.checkAndSaveResource("website/register.html");
        this.checkAndSaveResource("website/user/user.html");
        this.checkAndSaveResource("data/data.db");
        this.saveResource("language/zh-cn.yml", true);
        this.saveResource("language/en-eu.yml", true);
    }

    private void checkAndSaveResource(String filePath) {
        if (!this.isFileExists(filePath)) {
            this.saveResource(filePath, false);
        }
    }

    private boolean isFileExists(String filePath) {
        File file = new File(this.getDataFolder(), filePath);
        return file.exists() && file.isFile();
    }

    public void onDisable() {
        File tempfolder = new File("plugins/CSNKTools/temp");
        CSNKTools.deleteFolder(tempfolder);
        if (this.getConfig().getBoolean("smtp.Enable") && this.getConfig().getBoolean("serverendisable.enable")) {
            this.serverendisaBle.serverdisable();
        }
        this.getMessage("Console.enable");
        Bukkit.getConsoleSender().sendMessage(new String[0]);
    }

    public static void deleteFolder(File folder) {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                CSNKTools.deleteFolder(file);
            }
        }
        folder.delete();
    }

    public static void createNecessary() {
        CSNKTools.createPath("plugins/CSNKTools/music/");
    }

    public static void createPath(String path) {
        String directoryPath = path;
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            boolean bl = directory.mkdirs();
        } else {
            System.out.println("Directory already exists");
        }
    }
}

