/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.csnktools.website;

import com.crystalneko.csnktools.CSNKTools;
import com.crystalneko.csnktools.CTTool.HtmlPlaceholderConverter;
import com.crystalneko.csnktools.CTTool.mysqlandemail2;
import com.crystalneko.csnktools.CTTool.sqlite;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class UserServlet
extends HttpServlet {
    private String[] placeholders = new String[]{"<online />", "<max_online />", "<motd />", "<list_ban />", "<list_op />", "<player_name />", "<player_uuid />"};
    private String[] replacements;
    private HtmlPlaceholderConverter htmlPlaceholderConverter;
    private mysqlandemail2 mysqlAndemail2;
    private CSNKTools plugin;
    private sqlite sqLite;

    public UserServlet(HtmlPlaceholderConverter htmlPlaceholderConverter, mysqlandemail2 mysqlAndemail2, CSNKTools plugin, sqlite sqLite) {
        this.htmlPlaceholderConverter = htmlPlaceholderConverter;
        this.mysqlAndemail2 = mysqlAndemail2;
        this.plugin = plugin;
        this.sqLite = sqLite;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        String username = request.getParameter("username");
        Long logintime = Long.parseLong(this.mysqlAndemail2.read_table_where_data("logged", this.plugin.getConfig().getString("website.user_table"), "username", username));
        long currentTimeStamp = System.currentTimeMillis();
        long istime = currentTimeStamp - logintime;
        if (istime <= 1800000L) {
            File htmlfile = new File("plugins/CSNKTools/website/user" + pathInfo + ".html");
            String htmlpath = "plugins/CSNKTools/website/user" + pathInfo + ".html";
            if (htmlfile.exists()) {
                this.setPlaceholders(username);
                this.htmlPlaceholderConverter.startConverter(this.placeholders, this.replacements, String.valueOf(htmlfile));
                String convertedhtml = this.htmlPlaceholderConverter.convertedHtml;
                response.setContentType("text/html;charset=UTF-8");
                response.getWriter().write(convertedhtml);
            } else {
                response.sendRedirect("../404.html");
            }
        } else {
            response.sendRedirect("../login.html");
        }
    }

    public void setPlaceholders(String username) {
        Server server = Bukkit.getServer();
        int online = server.getOnlinePlayers().size();
        int maxonline = server.getMaxPlayers();
        String motd = ChatColor.stripColor((String)server.getMotd());
        ArrayList<String> banList = new ArrayList<String>();
        for (OfflinePlayer player : server.getBannedPlayers()) {
            banList.add(player.getName());
        }
        ArrayList<String> opList = new ArrayList<String>();
        for (OfflinePlayer player : server.getOperators()) {
            opList.add(player.getName());
        }
        String uuid = this.sqLite.getColumnValue(this.plugin.getConfig().getString("sqlite.player_data_table"), "uuid", "name", username);
        this.replacements = new String[]{String.valueOf(online), String.valueOf(maxonline), motd, ((Object)banList).toString(), ((Object)opList).toString(), username, uuid};
        int length = this.replacements.length;
        for (int i = 0; length - 1 > i; ++i) {
            if (this.replacements[i] != null) continue;
            this.replacements[i] = "N/A";
        }
    }
}

