/*
 * Decompiled with CFR 0.152.
 */
package net.byteflux.libby.logging.adapters;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.byteflux.libby.logging.LogLevel;
import net.byteflux.libby.logging.adapters.LogAdapter;

public class JDKLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JDKLogAdapter(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void log(LogLevel level, String message2) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, message2);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, message2);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, message2);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, message2);
            }
        }
    }

    @Override
    public void log(LogLevel level, String message2, Throwable throwable) {
        switch (Objects.requireNonNull(level, "level")) {
            case DEBUG: {
                this.logger.log(Level.FINE, message2, throwable);
                break;
            }
            case INFO: {
                this.logger.log(Level.INFO, message2, throwable);
                break;
            }
            case WARN: {
                this.logger.log(Level.WARNING, message2, throwable);
                break;
            }
            case ERROR: {
                this.logger.log(Level.SEVERE, message2, throwable);
            }
        }
    }
}

