/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.ctlibfabric.sql;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class sqlite {
    private static Connection sqliteconnection;

    public static Connection createConnection() throws SQLException {
        if (sqliteconnection != null && !sqliteconnection.isClosed()) {
            return sqliteconnection;
        }
        String sqlitePath = "ctlib/data.db";
        File sqliteFile = new File(sqlitePath);
        if (!sqliteFile.exists()) {
            File parentDir = sqliteFile.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            try {
                sqliteFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        String sqliteConnectionUrl = "jdbc:sqlite:" + sqlitePath;
        sqliteconnection = DriverManager.getConnection(sqliteConnectionUrl);
        return sqliteconnection;
    }

    public static void saveData(String tableName, String columnName, String data) {
        if (!sqlite.isTableExists(tableName)) {
            sqlite.createTable(tableName);
        }
        sqlite.addColumn(tableName, columnName);
        String query = "INSERT INTO " + tableName + " (" + columnName + ") VALUES (?)";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.setString(1, data);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkValueExists(String tableName, String columnName, String value) {
        String query = "SELECT COUNT(*) FROM " + tableName + " WHERE " + columnName + " = ?";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.setString(1, value);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return false;
            int count = resultSet.getInt(1);
            boolean bl = count > 0;
            return bl;
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        return false;
    }

    public static void saveDataWhere(String tableName, String columnName, String whereName, String whereValue, String columnValue) {
        if (!sqlite.isTableExists(tableName)) {
            sqlite.createTable(tableName);
        }
        sqlite.addColumn(tableName, columnName);
        String query = "UPDATE " + tableName + " SET " + columnName + " = ? WHERE " + whereName + " = ?";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.setString(1, columnValue);
            statement.setString(2, whereValue);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getColumnValue(String tableName, String columnName, String whereName, String whereValue) {
        if (!sqlite.isTableExists(tableName)) {
            sqlite.createTable(tableName);
        }
        sqlite.addColumn(tableName, columnName);
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + whereName + "=?";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.setString(1, whereValue);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String string = resultSet.getString(columnName);
                return string;
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        return null;
    }

    public static String[] readAllValueInAColumn(String tableName, String columnName) {
        String[] stringArray;
        block9: {
            String query = "SELECT " + columnName + " FROM " + tableName;
            PreparedStatement statement = sqliteconnection.prepareStatement(query);
            try {
                ResultSet result = statement.executeQuery();
                ArrayList<String> names = new ArrayList<String>();
                while (result.next()) {
                    String name = result.getString(columnName);
                    names.add(name);
                }
                String[] namesArray = new String[names.size()];
                names.toArray(namesArray);
                stringArray = namesArray;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.out.println(e);
                    return new String[0];
                }
            }
            statement.close();
        }
        return stringArray;
    }

    public static Boolean deleteLine(String tableName, String whereColumn, String whereValue) {
        Boolean bl;
        block8: {
            String query = "DELETE FROM " + tableName + " WHERE " + whereColumn + " = ?";
            PreparedStatement statement = sqliteconnection.prepareStatement(query);
            try {
                statement.setString(1, whereValue);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.out.println(e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public static boolean isTableExists(String tableName) {
        try {
            DatabaseMetaData metaData = sqliteconnection.getMetaData();
            ResultSet resultSet = metaData.getTables(null, null, tableName, null);
            return resultSet.next();
        }
        catch (SQLException e) {
            System.out.println(e);
            return false;
        }
    }

    public static void createTable(String tableName) {
        String query = "CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY AUTOINCREMENT)";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    private static boolean isColumnExists(String tableName, String columnName) {
        try {
            DatabaseMetaData metaData = sqliteconnection.getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, tableName, columnName);
            return resultSet.next();
        }
        catch (SQLException e) {
            System.out.println(e);
            return false;
        }
    }

    public static void addColumn(String tableName, String columnName) {
        if (sqlite.checkColumnExists(tableName, columnName)) {
            return;
        }
        String query = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " TEXT";
        try (PreparedStatement statement = sqliteconnection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public static boolean checkColumnExists(String tableName, String columnName) {
        boolean bl;
        block8: {
            ResultSet resultSet = sqliteconnection.getMetaData().getColumns(null, null, tableName, columnName);
            try {
                bl = resultSet.next();
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    System.out.println(e);
                    return false;
                }
            }
            resultSet.close();
        }
        return bl;
    }
}

