/*
 * Decompiled with CFR 0.152.
 */
package net.byteflux.libby.logging;

import java.util.Objects;
import net.byteflux.libby.logging.LogLevel;
import net.byteflux.libby.logging.adapters.LogAdapter;

public class Logger {
    private final LogAdapter adapter;
    private LogLevel level = LogLevel.INFO;

    public Logger(LogAdapter adapter) {
        this.adapter = Objects.requireNonNull(adapter, "adapter");
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = Objects.requireNonNull(level, "level");
    }

    private boolean canLog(LogLevel level) {
        return Objects.requireNonNull(level, "level").compareTo(this.level) >= 0;
    }

    public void log(LogLevel level, String message2) {
        if (this.canLog(level)) {
            this.adapter.log(level, message2);
        }
    }

    public void log(LogLevel level, String message2, Throwable throwable) {
        if (this.canLog(level)) {
            this.adapter.log(level, message2, throwable);
        }
    }

    public void debug(String message2) {
        this.log(LogLevel.DEBUG, message2);
    }

    public void debug(String message2, Throwable throwable) {
        this.log(LogLevel.DEBUG, message2, throwable);
    }

    public void info(String message2) {
        this.log(LogLevel.INFO, message2);
    }

    public void info(String message2, Throwable throwable) {
        this.log(LogLevel.INFO, message2, throwable);
    }

    public void warn(String message2) {
        this.log(LogLevel.WARN, message2);
    }

    public void warn(String message2, Throwable throwable) {
        this.log(LogLevel.WARN, message2, throwable);
    }

    public void error(String message2) {
        this.log(LogLevel.ERROR, message2);
    }

    public void error(String message2, Throwable throwable) {
        this.log(LogLevel.ERROR, message2, throwable);
    }
}

