/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class JsonConfiguration {
    private Map<String, Object> configData;
    private Gson gson;
    private Path filePath;

    public JsonConfiguration(Path filePath) throws IOException {
        this.filePath = filePath;
        this.gson = new Gson();
        this.configData = this.loadConfigData(filePath);
    }

    public JsonConfiguration(String jsonString) {
        this.gson = new Gson();
        this.configData = jsonString == null ? new HashMap<String, Object>() : (Map)this.gson.fromJson(jsonString, new TypeToken<Map<String, Object>>(){}.getType());
    }

    private Map<String, Object> loadConfigData(Path filePath) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            try (FileReader reader = new FileReader(filePath.toFile());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
                return map;
            }
        }
        return new HashMap<String, Object>();
    }

    public String getString(String key) {
        return (String)this.configData.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.configData.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.configData.get(key);
    }

    public Object get(String key) {
        return this.configData.get(key);
    }

    public void set(String key, Object value) {
        this.configData.put(key, value);
    }

    public void save() throws IOException {
        try (FileWriter writer = new FileWriter(this.filePath.toFile());){
            this.gson.toJson(this.configData, (Appendable)writer);
        }
    }
}

