/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import java.io.IOException;
import org.cneko.ctlib.common.file.JsonConfiguration;
import org.cneko.ctlib.common.file.MemoryFileSystem;
import org.cneko.ctlib.common.file.Resources;
import org.jetbrains.annotations.NotNull;

public class AssetsFile {
    private MemoryFileSystem files;

    public AssetsFile(MemoryFileSystem memoryFileSystem) {
        this.files = memoryFileSystem;
    }

    public AssetsFile(Resources resources, String modID) throws IOException {
        this.files = resources.readDirectoryFromJar("assets/" + modID);
    }

    public LanguageAssets getLanguageAssets() throws IOException {
        return new LanguageAssets(this.files.readDirectory("lang/"));
    }

    public static class LanguageAssets
    implements Assets {
        private MemoryFileSystem files;
        private String defaultLanguage;

        public LanguageAssets(MemoryFileSystem memoryFileSystem) {
            this.files = memoryFileSystem;
            this.defaultLanguage = "en_us";
        }

        public void setDefaultLanguage(@NotNull String lang) {
            this.defaultLanguage = lang;
        }

        public String get(@NotNull String key, @NotNull String lang) {
            try {
                String file = null;
                try {
                    file = this.files.readFile(lang + ".json", null);
                }
                catch (IOException e) {
                    return key;
                }
                JsonConfiguration json = JsonConfiguration.of(file);
                String value = json.getString(key);
                if (value == null && !lang.equals("en_us")) {
                    String EnglishFile = this.files.readFile("en_us.json", null);
                    JsonConfiguration EnglishJson = JsonConfiguration.of(EnglishFile);
                    value = EnglishJson.getString(key);
                }
                if (value == null) {
                    value = key;
                }
                return value;
            }
            catch (Exception e) {
                return key;
            }
        }

        public String get(@NotNull String key) {
            return this.get(key, this.defaultLanguage);
        }
    }

    public static interface Assets {
    }
}

