/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cneko.ctlib.common.file.Configure;
import org.cneko.ctlib.common.file.JsonConfiguration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration
implements Configure {
    private final Map<String, Object> data;
    private final Path path;

    public YamlConfiguration(Path path) throws IOException {
        this.path = path;
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                Yaml yaml = new Yaml();
                this.data = (Map)yaml.load(in);
            }
        } else {
            this.data = new LinkedHashMap<String, Object>();
        }
    }

    public YamlConfiguration(File file) throws IOException {
        this(file.toPath());
    }

    public YamlConfiguration(String yamlContent) {
        Yaml yaml = new Yaml();
        this.data = (Map)yaml.load(yamlContent);
        this.path = null;
    }

    @Override
    public Object get(String path) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            if ((current = (Map)current.get(keys[i])) != null) continue;
            return null;
        }
        return current.get(keys[keys.length - 1]);
    }

    @Override
    public void set(String path, Object value) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            current = (Map)current.computeIfAbsent((String)keys[i], k -> new LinkedHashMap());
        }
        current.put(keys[keys.length - 1], value);
        try {
            this.save();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void save() throws IOException {
        if (this.path == null) {
            return;
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (OutputStream out = Files.newOutputStream(this.path, new OpenOption[0]);){
            yaml.dump(this.data, (Writer)new OutputStreamWriter(out));
        }
    }

    public void save(Path targetPath) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
            yaml.dump(this.data, (Writer)new OutputStreamWriter(out));
        }
    }

    public void save(File targetFile) throws IOException {
        this.save(targetFile.toPath());
    }

    @Override
    public String getString(String path) {
        return (String)this.get(path);
    }

    @Override
    public List<String> getStringList(String path) {
        return (List)this.get(path);
    }

    @Override
    public float getFloat(String path) {
        Object value = this.get(path);
        return value instanceof Float ? ((Float)value).floatValue() : 0.0f;
    }

    @Override
    public double getDouble(String path) {
        Object value = this.get(path);
        return value instanceof Double ? (Double)value : 0.0;
    }

    @Override
    public int getInt(String path) {
        Object value = this.get(path);
        return value instanceof Integer ? (Integer)value : 0;
    }

    @Override
    public boolean getBoolean(String path) {
        Object value = this.get(path);
        return value instanceof Boolean && (Boolean)value != false;
    }

    @Override
    public boolean getBoolean(String path, boolean defValue) {
        Object value = this.get(path);
        return value instanceof Boolean ? (Boolean)value : defValue;
    }

    @Override
    public boolean isSet(String path) {
        return this.get(path) != null;
    }

    @Override
    public boolean contains(String path) {
        return this.isSet(path);
    }

    @Override
    public ArrayList<Integer> getIntList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Integer)) continue;
                list.add((Integer)obj);
            }
            return list;
        }
        return new ArrayList<Integer>();
    }

    @Override
    public ArrayList<Double> getDoubleList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Double)) continue;
                list.add((Double)obj);
            }
            return list;
        }
        return new ArrayList<Double>();
    }

    @Override
    public ArrayList<Float> getFloatList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            ArrayList<Float> list = new ArrayList<Float>();
            for (Object obj : (List)value) {
                if (!(obj instanceof Float)) continue;
                list.add((Float)obj);
            }
            return list;
        }
        return new ArrayList<Float>();
    }

    @Override
    public ArrayList<Object> getList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            return new ArrayList<Object>((List)value);
        }
        return new ArrayList<Object>();
    }

    @Override
    public String toString() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        return yaml.dump(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        return obj.toString().equals(this.toString());
    }

    @Override
    public boolean equalsCaseIgnoreCase(Object obj) {
        if (obj.toString() != null) {
            return obj.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }

    public static JsonConfiguration toJson(String yamlContent) {
        Yaml yaml = new Yaml();
        Map yamlMap = (Map)yaml.load(yamlContent);
        Gson gson = new Gson();
        return JsonConfiguration.of(gson.toJson((Object)yamlMap));
    }

    public static YamlConfiguration fromFile(Path filePath) throws IOException {
        return new YamlConfiguration(filePath);
    }

    public static YamlConfiguration fromFile(File file) throws IOException {
        return new YamlConfiguration(file.toPath());
    }

    public static YamlConfiguration of(String jsonString) {
        return new YamlConfiguration(jsonString);
    }
}

