/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.plugin.util.meta;

import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.cneko.ctlib.common.util.meta.PluginMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitMeta
implements PluginMeta {
    private final JavaPlugin plugin;
    private final PluginMeta.Description description;
    private final PluginMeta.Server server;

    public BukkitMeta(JavaPlugin plugin) {
        this.plugin = plugin;
        this.description = new BukkitDescription(plugin);
        this.server = new BukkitServer();
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    @NotNull
    public PluginMeta.Description getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public PluginMeta.Server getServer() {
        return this.server;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public static class BukkitDescription
    implements PluginMeta.Description {
        private final JavaPlugin plugin;

        public BukkitDescription(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        @NotNull
        public String getName() {
            return this.plugin.getName();
        }

        @Override
        @NotNull
        public String getId() {
            return this.plugin.getDescription().getName();
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.plugin.getDescription().getDescription();
        }

        @Override
        @Nullable
        public String getWebsite() {
            return this.plugin.getDescription().getWebsite();
        }

        @Override
        public String[] getAuthors() {
            return this.plugin.getDescription().getAuthors().toArray(new String[100]);
        }
    }

    public static class BukkitServer
    implements PluginMeta.Server {
        @Override
        public boolean isOnlineMode() {
            return Bukkit.getOnlineMode();
        }

        @Override
        public String getVersion() {
            return Bukkit.getVersion();
        }

        @Override
        public String getName() {
            return Bukkit.getName();
        }

        @Override
        @Nullable
        public String getMotd() {
            return Bukkit.getMotd();
        }

        @Override
        public int getPlayerAmount() {
            return Bukkit.getOnlinePlayers().size();
        }

        @Override
        public int getMaxPlayers() {
            return Bukkit.getMaxPlayers();
        }

        @Override
        @Nullable
        public PluginMeta.Server.GameMode getServerGamemode() {
            switch (Bukkit.getDefaultGameMode()) {
                case SURVIVAL: {
                    return PluginMeta.Server.GameMode.SURVIVAL;
                }
                case CREATIVE: {
                    return PluginMeta.Server.GameMode.CREATIVE;
                }
                case ADVENTURE: {
                    return PluginMeta.Server.GameMode.ADVENTURE;
                }
                case SPECTATOR: {
                    return PluginMeta.Server.GameMode.SPECTATOR;
                }
            }
            return PluginMeta.Server.GameMode.UNKNOWN;
        }
    }
}

