/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cneko.ctlib.common.network.HttpBase;

public class HttpPost {

    public static class HttpPostObject
    extends HttpBase.HttpBaseObject {
        private String postData;

        public HttpPostObject(String url, String postData) {
            super(url);
            this.postData = postData;
        }

        public HttpPostObject(String url, String postData, String contentType) {
            super(url);
            if (contentType != null) {
                if (this.headers == null) {
                    this.headers = new HashMap();
                }
                this.headers.put("Content-Type", contentType);
            }
            this.postData = postData;
        }

        @Override
        public HttpBase.HttpMethod getMethod() {
            return HttpBase.HttpMethod.POST;
        }

        public void setPostData(String postData) {
            this.postData = postData;
        }

        public String getPostData() {
            return this.postData;
        }

        @Override
        public void connect() throws IOException {
            int responseCode;
            URL u = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod(this.method.toString());
            for (Map.Entry<String, String> entry : this.getCookie().entrySet()) {
                conn.setRequestProperty("Cookie", entry.getKey() + "=" + entry.getValue());
            }
            if (this.headers != null) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.postData != null && !this.postData.isEmpty()) {
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] byArray = this.postData.getBytes(StandardCharsets.UTF_8);
                    os.write(byArray);
                }
            }
            this.responseCode = responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                bufferedReader.close();
                this.response = response.toString();
            } else {
                this.response = null;
            }
            Map<String, List<String>> map = conn.getHeaderFields();
            StringBuilder headers = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                headers.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
            this.responseHeaders = headers.toString();
        }
    }
}

