/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.cneko.ctlib.common.file.MemoryFileSystem;

public class Resources {
    private File file;
    private File tempDir;

    public Resources(Path jar) {
        this.file = jar.toFile();
    }

    public Resources(File jar) {
        this.file = jar;
    }

    public Resources(Class<?> clazz) throws URISyntaxException {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        this.file = new File(url.getFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFileFromJar(String resourcePath, String targetPath) throws IOException {
        if (resourcePath == null || targetPath == null) {
            throw new IllegalArgumentException("Resource path and target path cannot be null.");
        }
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.file));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().equals(resourcePath)) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(targetPath);
                try {
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                        fileOutputStream.write(buffer, 0, bytesRead);
                    }
                    return;
                }
                finally {
                    fileOutputStream.close();
                    return;
                }
            }
        }
    }

    public void copyDirectoryFromJar(String resourcePath, String targetPath) throws IOException {
        if (resourcePath == null || targetPath == null) {
            throw new IllegalArgumentException("Resource path and target path cannot be null.");
        }
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.file));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String entryPath = jarEntry.getName();
                if (!entryPath.startsWith(resourcePath + "/")) continue;
                String relativePath = entryPath.substring(resourcePath.length() + 1);
                File targetFile = new File(targetPath, relativePath);
                File targetDir = targetFile.getParentFile();
                if (targetDir != null && !targetDir.exists()) {
                    targetDir.mkdirs();
                }
                if (jarEntry.isDirectory()) {
                    targetFile.mkdirs();
                    continue;
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                        fileOutputStream.write(buffer, 0, bytesRead);
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readFileFromJar(String resourcePath) throws IOException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Resource path cannot be null.");
        }
        StringBuilder content = new StringBuilder();
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.file));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().equals(resourcePath)) continue;
                InputStreamReader inputStreamReader = new InputStreamReader(jarInputStream);
                try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        content.append(line).append("\n");
                    }
                    return content.toString().trim();
                }
                finally {
                    inputStreamReader.close();
                    return content.toString().trim();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryFileSystem readDirectoryFromJar(String resourcePath) throws IOException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Resource path cannot be null.");
        }
        MemoryFileSystem memoryFileSystem = new MemoryFileSystem();
        String tempDirPrefix = "memory-fs-";
        File tempDir = null;
        while (tempDir == null) {
            try {
                tempDir = File.createTempFile(tempDirPrefix, null);
            }
            catch (IOException e) {
                System.err.println("Failed to create temporary file: " + e.getMessage());
            }
        }
        tempDir.delete();
        tempDir.mkdirs();
        try {
            this.copyDirectoryFromJar(resourcePath, tempDir.getAbsolutePath());
            this.tempDir = tempDir;
            this.buildMemoryFileSystemFromDir(tempDir, memoryFileSystem);
        }
        finally {
            this.deleteDirectory(tempDir);
        }
        return memoryFileSystem;
    }

    private void buildMemoryFileSystemFromDir(File dir, MemoryFileSystem memoryFileSystem) throws IOException {
        for (File file : dir.listFiles()) {
            String name = file.getName();
            if (file.isDirectory()) {
                this.buildMemoryFileSystemFromDir(file, memoryFileSystem);
                continue;
            }
            name = file.getPath();
            name = name.replace(this.tempDir.getAbsolutePath(), "");
            name = name.substring(1);
            memoryFileSystem.addFile(name, Files.readAllBytes(file.toPath()));
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                this.deleteDirectory(file);
            }
        }
        if (!directory.delete()) {
            throw new IOException("Failed to delete directory: " + directory);
        }
    }
}

