/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.ctlib.common.network;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class PingTest {
    private String url;
    private long totalDelay;
    private int pingCount;

    public PingTest(String url) {
        this.url = url;
        this.totalDelay = 0L;
        this.pingCount = 0;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void ping(int times) {
        for (int i = 0; i < times; ++i) {
            long start = System.currentTimeMillis();
            try {
                URL obj = new URL(this.url);
                HttpURLConnection connection = (HttpURLConnection)obj.openConnection();
                connection.setRequestMethod("HEAD");
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) continue;
                long delay = System.currentTimeMillis() - start;
                this.totalDelay += delay;
                ++this.pingCount;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void ping() {
        this.ping(1);
    }

    public double getAverageDelay() {
        if (this.pingCount <= 0) {
            return 9999.0;
        }
        return (double)this.totalDelay / (double)this.pingCount;
    }

    public static double simplePing(String url) {
        PingTest pingTest = new PingTest(url);
        pingTest.ping();
        return pingTest.getAverageDelay();
    }
}

