/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko.command;

import com.crystalneko.toneko.ToNeko;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NekoCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ToNeko.getMessage("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        if (args[0].equalsIgnoreCase("help")) {
            player.sendMessage(ToNeko.getMessage("command.neko.help"));
        } else if (args[0].equalsIgnoreCase("jump")) {
            if (player.hasPermission("neko.command.jump")) {
                if (this.isPlayerNeko(player).booleanValue()) {
                    PotionEffectType effectType = PotionEffectType.JUMP;
                    int duration = this.getDuration(player);
                    int amplifier = this.getAmplifier(player);
                    this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                }
            } else {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
            }
        } else if (args[0].equalsIgnoreCase("vision")) {
            if (player.hasPermission("neko.command.vision")) {
                if (this.isPlayerNeko(player).booleanValue()) {
                    PotionEffectType effectType = PotionEffectType.NIGHT_VISION;
                    int duration = this.getDuration(player);
                    int amplifier = this.getAmplifier(player);
                    this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                }
            } else {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
            }
        } else {
            player.sendMessage(ToNeko.getMessage("command.neko.Invalid"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command2, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("help");
            completions.add("jump");
            completions.add("vision");
            return completions;
        }
        return Collections.emptyList();
    }

    private void givePlayerPotionEffect(Player player, PotionEffectType type, int duration, int amplifier) {
        PotionEffect effect = new PotionEffect(type, duration, amplifier);
        player.addPotionEffect(effect);
    }

    private Boolean isPlayerNeko(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        if (data.getString(player.getName() + ".owner") != null) {
            return true;
        }
        player.sendMessage(ToNeko.getMessage("command.neko.not-neko"));
        return false;
    }

    private int getAmplifier(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        int xp = data.getInt(player.getName() + ".xp");
        int duration = 1;
        if (xp >= 500 && xp < 1000) {
            duration = 2;
        } else if (xp >= 1000 && xp < 2000) {
            duration = 3;
        } else if (xp >= 2000 && xp < 4000) {
            duration = 4;
        } else if (xp >= 4000 && xp < 8000) {
            duration = 5;
        } else if (xp >= 8000 && xp < 16000) {
            duration = 6;
        } else if (xp >= 16000) {
            duration = 7;
        }
        return duration;
    }

    private int getDuration(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        int xp = data.getInt(player.getName() + ".xp");
        int duration = 12000;
        if (xp >= 500 && xp < 1000) {
            duration = 36000;
        } else if (xp >= 1000 && xp < 2000) {
            duration = 72000;
        } else if (xp >= 2000 && xp < 4000) {
            duration = 140000;
        } else if (xp >= 4000 && xp < 8000) {
            duration = 280000;
        } else if (xp >= 8000 && xp < 16000) {
            duration = 600000;
        } else if (xp >= 16000) {
            duration = 1000000;
        }
        return duration;
    }
}

