/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NekoCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c");
            return true;
        }
        Player player = (Player)sender;
        if (args[0].equalsIgnoreCase("help")) {
            player.sendMessage("\u00a7b/neko \u5e2e\u52a9:\n\u00a7a/neko help \u00a7b\u83b7\u53d6\u5e2e\u52a9\n\u00a7a/neko jump \u00a7b\u83b7\u53d6\u8df3\u8dc3\u63d0\u5347");
        } else if (args[0].equalsIgnoreCase("jump")) {
            if (player.hasPermission("neko.command.jump")) {
                if (this.isPlayerNeko(player).booleanValue()) {
                    PotionEffectType effectType = PotionEffectType.JUMP;
                    int duration = this.getDuration(player);
                    int amplifier = this.getAmplifier(player);
                    this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                }
            } else {
                player.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6267\u884c\u8be5\u547d\u4ee4\u7684\u6743\u9650!");
            }
        } else if (args[0].equalsIgnoreCase("vision")) {
            if (player.hasPermission("neko.command.vision")) {
                if (this.isPlayerNeko(player).booleanValue()) {
                    PotionEffectType effectType = PotionEffectType.NIGHT_VISION;
                    int duration = this.getDuration(player);
                    int amplifier = this.getAmplifier(player);
                    this.givePlayerPotionEffect(player, effectType, duration, amplifier);
                }
            } else {
                player.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6267\u884c\u8be5\u547d\u4ee4\u7684\u6743\u9650!");
            }
        } else {
            player.sendMessage("\u00a7c\u65e0\u6548\u7684\u5b50\u547d\u4ee4,\u8bf7\u8f93\u5165\u00a7a/neko help\u00a7c\u67e5\u770b\u5e2e\u52a9");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("help");
            completions.add("jump");
            completions.add("vision");
            return completions;
        }
        return Collections.emptyList();
    }

    private void givePlayerPotionEffect(Player player, PotionEffectType type, int duration, int amplifier) {
        PotionEffect effect = new PotionEffect(type, duration, amplifier);
        player.addPotionEffect(effect);
    }

    private Boolean isPlayerNeko(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        if (data.getString(player.getName() + ".owner") != null) {
            return true;
        }
        player.sendMessage("\u00a7c\u4f60\u4e0d\u662f\u732b\u5a18\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u547d\u4ee4");
        return false;
    }

    private int getAmplifier(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        int xp = data.getInt(player.getName() + ".xp");
        int duration = 1;
        if (xp >= 500 && xp < 1000) {
            duration = 2;
        } else if (xp >= 1000 && xp < 2000) {
            duration = 3;
        } else if (xp >= 2000 && xp < 4000) {
            duration = 4;
        } else if (xp >= 4000 && xp < 8000) {
            duration = 5;
        } else if (xp >= 8000 && xp < 16000) {
            duration = 6;
        } else if (xp >= 16000) {
            duration = 7;
        }
        return duration;
    }

    private int getDuration(Player player) {
        File dataFile = new File("plugins/toNeko/nekos.yml");
        YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
        int xp = data.getInt(player.getName() + ".xp");
        int duration = 12000;
        if (xp >= 500 && xp < 1000) {
            duration = 36000;
        } else if (xp >= 1000 && xp < 2000) {
            duration = 72000;
        } else if (xp >= 2000 && xp < 4000) {
            duration = 140000;
        } else if (xp >= 4000 && xp < 8000) {
            duration = 280000;
        } else if (xp >= 8000 && xp < 16000) {
            duration = 600000;
        } else if (xp >= 16000) {
            duration = 1000000;
        }
        return duration;
    }
}

