/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.libs;

import java.nio.file.Path;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class Translatable
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LangProvider::new);
    }

    private static class LangProvider
    extends FabricLanguageProvider {
        private LangProvider(FabricDataOutput dataGenerator) {
            super(dataGenerator, "zh_cn");
        }

        public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
            try {
                Path zhCnFilePath = (Path)this.dataOutput.getModContainer().findPath("assets/tonekofabric/lang/zh_cn.json").get();
                translationBuilder.add(zhCnFilePath);
            }
            catch (Exception e) {
                throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7dzh_cn\u8bed\u8a00", e);
            }
            try {
                Path enUsFilePath = (Path)this.dataOutput.getModContainer().findPath("assets/tonekofabric/lang/en_us.json").get();
                translationBuilder.add(enUsFilePath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to add en_us language file!", e);
            }
        }
    }
}

