/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko;

import com.crystalneko.toneko.bstats.Metrics;
import com.crystalneko.toneko.chat.nekoed;
import com.crystalneko.toneko.command.NekoCommand;
import com.crystalneko.toneko.command.TabCompleter;
import com.crystalneko.toneko.command.ToNekoCommand;
import com.crystalneko.toneko.event.PlayerAttack;
import com.crystalneko.toneko.event.PlayerDeath;
import com.crystalneko.toneko.event.PlayerJoin;
import com.crystalneko.toneko.event.PlayerQuit;
import com.crystalneko.toneko.files.create;
import com.crystalneko.toneko.files.downloadPlugin;
import com.crystalneko.toneko.items.getStick;
import com.crystalneko.toneko.items.stickLevel2;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class ToNeko
extends JavaPlugin {
    private create createFile;
    private nekoed catedChat;
    private getStick getstick;
    private PlayerDeath playerDeath;
    private downloadPlugin DownloadPlugin;
    private PlayerJoin playerJoin;
    private PlayerAttack playerAttack;
    public static FileConfiguration languageConfig;
    private String language;
    private PlayerQuit playerQuit;
    public stickLevel2 stickLevel;
    public static Logger logger;

    public void onEnable() {
        logger = Logger.getLogger("toNeko");
        int pluginId = 19899;
        Metrics metrics = new Metrics(this, pluginId);
        downloadPlugin.checkAndDownloadPlugin("ctLib", "https://w.csk.asia/res/plugins/ctLib.jar");
        this.checkAndSaveResource("config.yml");
        this.updateConfig();
        this.copyResource();
        this.loadLanguageFile();
        this.DownloadPlugin = new downloadPlugin(this);
        this.automaticUpdates();
        this.createFile = new create();
        this.createFile.createNewFile("plugins/toNeko/nekos.yml");
        this.catedChat = new nekoed(this);
        this.getstick = new getStick(this);
        this.getCommand("toneko").setExecutor((CommandExecutor)new ToNekoCommand(this, this.getstick));
        this.getCommand("neko").setExecutor((CommandExecutor)new NekoCommand());
        this.getCommand("toneko").setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.getCommand("neko").setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.playerJoin = new PlayerJoin(this);
        this.playerQuit = new PlayerQuit(this);
        this.playerAttack = new PlayerAttack(this);
        this.playerDeath = new PlayerDeath(this);
        this.stickLevel = new stickLevel2();
        this.stickLevel.stickLevel2(this);
    }

    public void onDisable() {
    }

    private void checkAndSaveResource(String filePath) {
        if (!this.isFileExists(filePath)) {
            this.saveResource(filePath, false);
        }
    }

    private boolean isFileExists(String filePath) {
        File file = new File(this.getDataFolder(), filePath);
        return file.exists() && file.isFile();
    }

    public Boolean checkUpdates() {
        String remoteUrl = "https://w.csk.asia/res/version/toNeko.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    System.out.println(ToNeko.getMessage("onEnable.new-version"));
                    connection.disconnect();
                    return true;
                }
                System.out.println(ToNeko.getMessage("onEnable.up-to-date"));
                connection.disconnect();
                return false;
            }
            System.out.println(ToNeko.getMessage("onEnable.unable-check-update"));
            connection.disconnect();
            return false;
        }
        catch (IOException e) {
            System.out.println(ToNeko.getMessage("onEnable.unable-check-update") + ":" + e);
            return false;
        }
    }

    public void automaticUpdates() {
        Boolean needUpdate;
        if (this.getConfig().getBoolean("automatic-updates") && (needUpdate = this.checkUpdates()).booleanValue()) {
            try {
                downloadPlugin.downloadFile("https://w.csk.asia/res/plugins/toNeko.jar", "plugins/toNeko" + this.getDescription().getVersion() + "[+].jar");
                this.DownloadPlugin.deletePlugin();
                PluginManager pluginManager = Bukkit.getPluginManager();
                try {
                    pluginManager.loadPlugin(new File("plugins/toNeko" + this.getDescription().getVersion() + "[+].jar"));
                }
                catch (InvalidPluginException e) {
                    throw new RuntimeException(e);
                }
                catch (InvalidDescriptionException e) {
                    throw new RuntimeException(e);
                }
                pluginManager.enablePlugin(pluginManager.getPlugin("toNeko"));
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    private void updateConfig() {
        File backupFile = new File("plugins/toNeko/config_old.yml");
        File configFile = new File("plugins/toNeko/config.yml");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        try {
            Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InputStream defaultConfigStream = this.getResource("config.yml");
        try {
            Files.copy(defaultConfigStream, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File newConfigFile = new File("plugins/toNeko/config.yml");
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)newConfigFile);
        newConfig.set("automatic-updates", (Object)this.ifConfig("automatic-updates"));
        newConfig.set("online", (Object)this.ifConfig("online"));
        newConfig.set("language", (Object)this.ifConfig("language"));
        try {
            newConfig.save(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String ifConfig(String option) {
        File oldConfigFile = new File("plugins/toNeko/config_old.yml");
        YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldConfigFile);
        if (oldConfig.getString(option) != null) {
            return oldConfig.getString(option);
        }
        File configFile = new File("plugins/toNeko/config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        return config.getString(option);
    }

    private void copyResource() {
        File targetFolder = new File(this.getDataFolder().getParentFile(), "toNeko");
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        this.saveResource("language/zh_cn.yml", true);
        this.saveResource("language/en_us.yml", true);
    }

    private void loadLanguageFile() {
        this.language = this.getConfig().getString("language");
        File languageFile = new File(this.getDataFolder(), "language/" + this.language + ".yml");
        if (!languageFile.exists()) {
            this.saveResource("language/" + this.language + ".yml", false);
        }
        languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    public static String getMessage(String key) {
        return languageConfig.getString(key);
    }

    public static String getMessage(String key, String[] replace) {
        String text = ToNeko.getMessage(key);
        text = text.replace("%d", replace[0]);
        if (replace.length == 2) {
            text = text.replace("%c", replace[1]);
        }
        return text;
    }
}

