/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko;

import com.crystalneko.ctlibPublic.sql.sqlite;
import com.crystalneko.toneko.bstats.Metrics;
import com.crystalneko.toneko.chat.NekoChatListener;
import com.crystalneko.toneko.command.AINekoCommand;
import com.crystalneko.toneko.command.NekoCommand;
import com.crystalneko.toneko.command.TabCompleter;
import com.crystalneko.toneko.command.ToNekoCommand;
import com.crystalneko.toneko.event.PlayerEventListenerBase;
import com.crystalneko.toneko.items.StickItemRecipeRegistry;
import com.crystalneko.toneko.utils.ConfigFileUtils;
import com.crystalneko.toneko.utils.LibraryDownloader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class ToNeko
extends JavaPlugin {
    private LibraryDownloader libraryDownloader;
    public static FileConfiguration languageConfig;
    public static Logger logger;
    public static YamlConfiguration config;
    public static ToNeko pluginInstance;

    public void onEnable() {
        pluginInstance = this;
        logger = Logger.getLogger("toNeko");
        int pluginId = 19899;
        Metrics metrics = new Metrics(this, pluginId);
        LibraryDownloader.checkAndDownloadPlugin("ctLib", "https://res.cneko.org/mc/plugins/ctlib.jar");
        this.checkAndSaveResource("assets/toneko/config.yml");
        this.updateConfig();
        this.initResourceFilesIfNeed();
        config = YamlConfiguration.loadConfiguration((File)new File("plugins/toNeko/config.yml"));
        this.loadLanguageFile();
        this.libraryDownloader = new LibraryDownloader(this);
        this.checkForUpdateIfNeed();
        ConfigFileUtils.createNewFile("plugins/toNeko/nekos.yml");
        new NekoChatListener().bootstrap();
        this.checkDataBase();
        TabCompleter tabCompleter = new TabCompleter();
        this.getCommand("toneko").setExecutor((CommandExecutor)new ToNekoCommand());
        this.getCommand("toneko").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("neko").setExecutor((CommandExecutor)new NekoCommand());
        this.getCommand("neko").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        this.getCommand("aineko").setExecutor((CommandExecutor)new AINekoCommand());
        this.getCommand("aineko").setTabCompleter((org.bukkit.command.TabCompleter)tabCompleter);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEventListenerBase(), (Plugin)this);
        StickItemRecipeRegistry.registerRecipe();
    }

    private void checkDataBase() {
        if (!sqlite.isTableExists((String)"nekoblockword")) {
            sqlite.createTable((String)"nekoblockword");
            sqlite.addColumn((String)"nekoblockword", (String)"block");
            sqlite.addColumn((String)"nekoblockword", (String)"replace");
            sqlite.addColumn((String)"nekoblockword", (String)"method");
            sqlite.addColumn((String)"nekoblockword", (String)"neko");
        }
    }

    public void onDisable() {
    }

    private void updateConfig() {
        File backupFile = new File("plugins/toNeko/config_old.yml");
        File configFile = new File("plugins/toNeko/config.yml");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        try {
            Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InputStream defaultConfigStream = this.getResource("assets/toneko/config.yml");
        try {
            Files.copy(defaultConfigStream, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File newConfigFile = new File("plugins/toNeko/config.yml");
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)newConfigFile);
        newConfig.set("automatic-updates", this.ifConfig("automatic-updates"));
        newConfig.set("language", this.ifConfig("language"));
        newConfig.set("AI.enable", this.ifConfig("AI.enable"));
        newConfig.set("AI.API", this.ifConfig("AI.API"));
        newConfig.set("AI.prompt", this.ifConfig("AI.prompt"));
        newConfig.set("chat.enable", this.ifConfig("chat.enable"));
        try {
            newConfig.save(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkAndSaveResource(String filePath) {
        if (!this.isFileExists(filePath.replace("assets/toneko/", ""))) {
            this.saveResource(filePath, false);
            Path file = Path.of("plugins/toNeko/" + filePath, new String[0]);
            try {
                Files.move(file, Path.of("plugins/toNeko/config.yml", new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                System.out.println("\u65e0\u6cd5\u79fb\u52a8\u6587\u4ef6");
            }
        }
    }

    private boolean isFileExists(String filePath) {
        File file = new File(this.getDataFolder(), filePath);
        return file.exists() && file.isFile();
    }

    public Boolean checkUpdates() {
        String remoteUrl = "https://w.csk.asia/res/version/toNeko.txt";
        try {
            URL url = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String remoteVersion = reader.readLine();
                reader.close();
                String pluginVersion = this.getDescription().getVersion();
                if (!pluginVersion.equals(remoteVersion)) {
                    System.out.println(ToNeko.getMessage("onEnable.new-version"));
                    connection.disconnect();
                    return true;
                }
                System.out.println(ToNeko.getMessage("onEnable.up-to-date"));
                connection.disconnect();
                return false;
            }
            System.out.println(ToNeko.getMessage("onEnable.unable-check-update"));
            connection.disconnect();
            return false;
        }
        catch (IOException e) {
            System.out.println(ToNeko.getMessage("onEnable.unable-check-update") + ":" + e);
            return false;
        }
    }

    public void checkForUpdateIfNeed() {
        Boolean needUpdate;
        if (this.getConfig().getBoolean("automatic-updates") && (needUpdate = this.checkUpdates()).booleanValue()) {
            try {
                LibraryDownloader.downloadFile("https://w.csk.asia/res/plugins/toNeko.jar", "plugins/toNeko" + this.getDescription().getVersion() + "[+].jar");
                this.libraryDownloader.deletePlugin();
                PluginManager pluginManager = Bukkit.getPluginManager();
                try {
                    pluginManager.loadPlugin(new File("plugins/toNeko" + this.getDescription().getVersion() + "[+].jar"));
                }
                catch (InvalidPluginException e) {
                    throw new RuntimeException(e);
                }
                catch (InvalidDescriptionException e) {
                    throw new RuntimeException(e);
                }
                pluginManager.enablePlugin(pluginManager.getPlugin("toNeko"));
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    private Object ifConfig(String option) {
        File oldConfigFile = new File("plugins/toNeko/config_old.yml");
        YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldConfigFile);
        if (oldConfig.get(option) != null) {
            return oldConfig.get(option);
        }
        File configFile = new File("plugins/toNeko/config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        return config.get(option);
    }

    private void initResourceFilesIfNeed() {
        File targetFolder = new File(this.getDataFolder().getParentFile(), "toNeko");
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        this.saveResource("language/zh_cn.yml", true);
        this.saveResource("language/en_us.yml", true);
    }

    private void loadLanguageFile() {
        String language = this.getConfig().getString("language");
        File languageFile = new File(this.getDataFolder(), "language/" + language + ".yml");
        if (!languageFile.exists()) {
            this.saveResource("language/" + language + ".yml", false);
        }
        languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
    }

    public static String getMessage(String key) {
        return languageConfig.getString(key);
    }

    public static String getMessage(String key, String[] replace) {
        String text = ToNeko.getMessage(key);
        text = text.replace("%d", replace[0]);
        if (replace.length == 2) {
            text = text.replace("%c", replace[1]);
        }
        return text;
    }
}

