/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.toneko.command;

import com.crystalneko.toneko.ToNeko;
import com.crystalneko.toneko.items.StickItemWrapper;
import com.crystalneko.toneko.utils.ConfigFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.cneko.ctlib.common.util.ChatPrefix;
import org.cneko.ctlib.common.util.LocalDataBase;
import org.jetbrains.annotations.NotNull;

public class ToNekoCommand
implements CommandExecutor {
    private final Map<Player, Boolean> confirmMap = new ConcurrentHashMap<Player, Boolean>();

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ToNeko.getMessage("command.only-player"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(ToNeko.getMessage("command.toneko.help"));
            return true;
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("player")) {
            if (!player.hasPermission("toneko.command.player")) {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
                return true;
            }
            File dataFile = new File("plugins/toNeko/nekos.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            Boolean created = ConfigFileUtils.createNewKey(args[1] + ".owner", player.getName(), data, dataFile);
            ConfigFileUtils.createNewKey(args[1] + ".xp", 0, data, dataFile);
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add("CrystalNekoooo");
            ConfigFileUtils.createNewKey(args[1] + ".aliases", aliases, data, dataFile);
            if (created.booleanValue()) {
                ToNekoCommand.killPlayer(player, args[1]);
                player.sendMessage(ToNeko.getMessage("command.toneko.player.success", new String[]{args[1]}));
                if (!ToNekoCommand.isPlayerOnline(args[1])) return true;
                Player neko = Bukkit.getPlayer((String)args[1]);
                if (neko == null) return true;
                ChatPrefix.addPrivatePrefix((String)neko.getName(), (String)ToNeko.getMessage("chat.neko.prefix"));
                return true;
            }
            player.sendMessage(ToNeko.getMessage("command.toneko.player.nekoed", new String[]{data.getString(args[1] + ".owner")}));
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            player.sendMessage(ToNeko.getMessage("command.toneko.help"));
            return true;
        }
        if (args[0].equalsIgnoreCase("item")) {
            if (player.hasPermission("toneko.command.item")) {
                StickItemWrapper.giveStickToPlayer(player);
                return true;
            }
            player.sendMessage(ToNeko.getMessage("command.no-permission"));
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
            if (!player.hasPermission("toneko.command.remove")) {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
                return true;
            }
            if (!this.confirmMap.getOrDefault(player, false).booleanValue()) {
                player.sendMessage(ToNeko.getMessage("command.toneko.remove.confirm") + ": /toneko remove " + args[1]);
                this.confirmMap.put(player, true);
                return true;
            }
            File dataFile = new File("plugins/toNeko/nekos.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            if (data.getString(args[1] + ".owner") != null) {
                if (Objects.requireNonNull(data.getString(args[1] + ".owner")).equalsIgnoreCase(player.getName())) {
                    Player neko = Bukkit.getPlayer((String)args[1]);
                    if (neko != null) {
                        ChatPrefix.removePrivatePrefix((String)neko.getName(), (String)ToNeko.getMessage("chat.neko.prefix"));
                        data.set(args[1] + ".owner", null);
                        data.set(args[1] + ".aliases", null);
                        ConfigFileUtils.setValue(args[1] + ".xp", 0, dataFile);
                        player.sendMessage(ToNeko.getMessage("command.toneko.remove.confirm") + args[1]);
                    } else {
                        player.sendMessage("\u00a7c\u732b\u5a18\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u7ebf");
                    }
                } else {
                    player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                }
            }
            this.confirmMap.remove(player);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("xp")) {
            if (!player.hasPermission("toneko.command.xp")) {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
                return true;
            }
            File dataFile = new File("plugins/toNeko/nekos.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            if (data.getString(args[1] + ".owner") != null) {
                if (Objects.requireNonNull(data.getString(args[1] + ".owner")).equalsIgnoreCase(player.getName())) {
                    int xp = data.getInt(args[1] + ".xp");
                    player.sendMessage("\u00a7a\u4f60\u4e0e\u00a7e" + args[1] + "\u00a7b\u7684\u597d\u611f\u7ecf\u9a8c\u4e3a\u00a7e" + xp);
                    return true;
                }
                player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                return true;
            }
            if (data.getString(args[1] + ".owner") != null) {
                if (!Objects.requireNonNull(data.getString(args[1] + ".owner")).equalsIgnoreCase(player.getName())) return true;
                ConfigFileUtils.createNewKey(args[1] + ".xp", player.getName(), data, dataFile);
                return true;
            }
            player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
            return true;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("aliases")) {
            if (!player.hasPermission("toneko.command.aliases")) {
                player.sendMessage(ToNeko.getMessage("command.no-permission"));
                return true;
            }
            File dataFile = new File("plugins/toNeko/nekos.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            if (data.getString(args[1] + ".owner") == null) {
                player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                return true;
            }
            if (!Objects.requireNonNull(data.getString(args[1] + ".owner")).equalsIgnoreCase(player.getName())) {
                player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                return true;
            }
            if (args[2].equalsIgnoreCase("add")) {
                if (data.getList(args[1] + ".aliases") != null) {
                    List aliases = data.getStringList(args[1] + ".aliases");
                    aliases.add(args[3]);
                    ConfigFileUtils.setValue(args[1] + ".aliases", aliases, dataFile);
                    player.sendMessage(ToNeko.getMessage("command.toneko.aliases.add.true") + args[3]);
                    return true;
                }
                ArrayList<String> aliases = new ArrayList<String>();
                aliases.add(args[3]);
                ConfigFileUtils.createNewKey(args[1] + ".aliases", aliases, data, dataFile);
                player.sendMessage(ToNeko.getMessage("command.toneko.aliases.add.true") + args[3]);
                return true;
            }
            if (!args[2].equalsIgnoreCase("remove")) {
                player.sendMessage("\u00a7c\u4f60\u7684\u547d\u4ee4/neko " + args[0] + " " + args[1] + "\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8f93\u5165\u7684\u662fadd\u6216remove");
                return true;
            }
            List aliases = data.getStringList(args[1] + ".aliases");
            if (aliases.contains(args[3])) {
                aliases.remove(args[3]);
                ConfigFileUtils.setValue(args[1] + ".aliases", aliases, dataFile);
                player.sendMessage(ToNeko.getMessage("command.toneko.aliases.remove.true"));
                return true;
            }
            player.sendMessage(ToNeko.getMessage("command.toneko.aliases.remove.no"));
            return true;
        }
        if (args.length == 6 && args[0].equalsIgnoreCase("block")) {
            File dataFile = new File("plugins/toNeko/nekos.yml");
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)dataFile);
            if (data.getString(args[1] + ".owner") == null) {
                player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                return true;
            }
            if (!Objects.requireNonNull(data.getString(args[1] + ".owner")).equalsIgnoreCase(player.getName())) {
                player.sendMessage(ToNeko.getMessage("command.toneko.notOwner", new String[]{args[1]}));
                return true;
            }
            if (!args[5].equalsIgnoreCase("all") && !args[5].equalsIgnoreCase("word")) {
                player.sendMessage(ToNeko.getMessage("command.parameter.error"));
                return true;
            }
            if (args[2].equalsIgnoreCase("add")) {
                LocalDataBase.Connections.sqlite.addColumn("nekoblockword", "block");
                LocalDataBase.Connections.sqlite.addColumn("nekoblockword", "replace");
                LocalDataBase.Connections.sqlite.addColumn("nekoblockword", "method");
                if (!LocalDataBase.Connections.sqlite.checkValueExists("nekoblockword", "neko", args[1])) {
                    LocalDataBase.Connections.sqlite.saveData("nekoblockword", "neko", args[1]);
                }
                Object block = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "block", "neko", args[1]);
                Object replace = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "replace", "neko", args[1]);
                Object method = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "method", "neko", args[1]);
                if (block != null) {
                    String[] blocks = ((String)block).split(",");
                    if (ToNekoCommand.contains(blocks, args[3])) {
                        player.sendMessage(ToNeko.getMessage("command.toneko.block.exists"));
                        return true;
                    }
                    block = (String)block + "," + args[3];
                    replace = (String)replace + "," + args[4];
                    method = (String)method + "," + args[5];
                } else {
                    block = args[3];
                    replace = args[4];
                    method = args[5];
                }
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "block", "neko", args[1], (String)block);
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "replace", "neko", args[1], (String)replace);
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "method", "neko", args[1], (String)method);
                player.sendMessage(ToNeko.getMessage("command.toneko.block.add.success"));
                return true;
            }
            if (!args[2].equalsIgnoreCase("remove")) return true;
            if (!LocalDataBase.Connections.sqlite.checkValueExists("nekoblockword", "neko", args[1])) {
                player.sendMessage(ToNeko.getMessage("command.toneko.block.no-exists"));
                return true;
            }
            String block = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "block", "neko", args[1]);
            String replace = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "replace", "neko", args[1]);
            String method = LocalDataBase.Connections.sqlite.getColumnValue("nekoblockword", "method", "neko", args[1]);
            if (block == null) return true;
            Object[] blocks = block.split(",");
            CharSequence[] replaces = replace.split(",");
            CharSequence[] methods = method.split(",");
            int index = Arrays.binarySearch(blocks, args[3]);
            if (index >= 0) {
                blocks = ToNekoCommand.deleteIndex((String[])blocks, index);
                replaces = ToNekoCommand.deleteIndex((String[])replaces, index);
                methods = ToNekoCommand.deleteIndex((String[])methods, index);
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "block", "neko", args[1], String.join((CharSequence)",", (CharSequence[])blocks));
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "replace", "neko", args[1], String.join((CharSequence)",", replaces));
                LocalDataBase.Connections.sqlite.saveDataWhere("nekoblockword", "method", "neko", args[1], String.join((CharSequence)",", methods));
                player.sendMessage(ToNeko.getMessage("command.toneko.block.remove.success"));
                return true;
            }
            player.sendMessage(ToNeko.getMessage("command.toneko.block.no-exists"));
            return true;
        }
        player.sendMessage(ToNeko.getMessage("command.neko.Invalid"));
        return true;
    }

    public static void killPlayer(Player player, String neko) {
        Bukkit.getServer().broadcastMessage(ToNeko.getMessage("command.toneko.player.death", new String[]{player.getName(), neko}));
        player.setHealth(0.0);
    }

    public static boolean isPlayerOnline(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        return player != null && player.isOnline();
    }

    public static String[] deleteIndex(String[] arr, int index) {
        for (int i = index; i < arr.length - 1; ++i) {
            arr[i] = arr[i + 1];
        }
        return Arrays.copyOf(arr, arr.length - 1);
    }

    public static boolean contains(String[] array, String value) {
        for (String str : array) {
            if (!str.equals(value)) continue;
            return true;
        }
        return false;
    }
}

