/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.libs;

import com.crystalneko.tonekofabric.ToNekoFabric;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.cneko.ctlib.common.file.YamlConfiguration;
import org.cneko.ctlib.common.util.LocalDataBase;

public class base {
    public static YamlConfiguration config;
    public static String dataFolder;
    public static String language;
    public static YamlConfiguration languageConfig;

    public base() {
        this.create();
        Path configFile = Path.of(dataFolder + "/config.yml", new String[0]);
        if (!Files.exists(configFile, new LinkOption[0])) {
            this.copyResource("/assets/toneko/config.yml", dataFolder, "assets/toneko/config.yml");
        }
        try {
            config = new YamlConfiguration(configFile);
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:" + e.getMessage());
        }
    }

    public static void start(String worldName) {
        if (!ToNekoFabric.started.booleanValue()) {
            if (!LocalDataBase.Connections.sqlite.isTableExists(worldName + "Nekos")) {
                LocalDataBase.Connections.sqlite.createTable(worldName + "Nekos");
            }
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "neko");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "owner");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "block");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "method");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "replace");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "xp");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "Nekos", "type");
            if (!LocalDataBase.Connections.sqlite.isTableExists(worldName + "NekoEnt")) {
                LocalDataBase.Connections.sqlite.createTable(worldName + "NekoEnt");
            }
            LocalDataBase.Connections.sqlite.addColumn(worldName + "NekoEnt", "uuid");
            LocalDataBase.Connections.sqlite.addColumn(worldName + "NekoEnt", "name");
        }
    }

    public static Boolean createFileInDirectory(String directoryPath, String fileName) throws IOException {
        String filePath = directoryPath + fileName;
        Path directory = Paths.get(directoryPath, new String[0]);
        Files.createDirectories(directory, new FileAttribute[0]);
        Path file = Paths.get(filePath, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
            return true;
        }
        return false;
    }

    public static String getPlayerName(class_1657 player) {
        String playerName = player.method_5477().getString();
        playerName = playerName.replace("literal{", "").replace("}", "");
        return playerName;
    }

    public static class_2561 getStringLanguage(String key, String[] replace) {
        return class_2561.method_43469((String)key, (Object[])replace);
    }

    public static String getWorldName(class_1937 world) {
        String name = world.toString();
        name = name.replace("[", "");
        name = name.replace("]", "");
        name = name.replace("ServerLevel", "");
        return name;
    }

    public void create() {
        this.createDirectoryIfNotExists(Path.of(dataFolder, new String[0]));
        this.createDirectoryIfNotExists(Path.of(dataFolder + "/language", new String[0]));
        this.createDirectoryIfNotExists(Path.of(dataFolder + "/assets", new String[0]));
        this.createDirectoryIfNotExists(Path.of(dataFolder + "/assets/toneko", new String[0]));
        this.deleteFileIfExists(Path.of(dataFolder + "/language/zh_cn.yml", new String[0]));
        this.deleteFileIfExists(Path.of(dataFolder + "/language/en_us.yml", new String[0]));
    }

    private void deleteFileIfExists(Path filePath) {
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.delete(filePath);
            }
            catch (IOException e) {
                System.out.println("\u65e0\u6cd5\u5220\u9664\u8bed\u8a00\u6587\u4ef6: " + e.getMessage());
            }
        }
    }

    private void createDirectoryIfNotExists(Path directoryPath) {
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(directoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println("Can not create path: " + e.getMessage());
            }
        }
    }

    public void copyResource(String resourcePath, String dataFolder, String fileName) {
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in == null) {
                System.out.println("\u65e0\u6cd5\u627e\u5230\u8d44\u6e90\u6587\u4ef6");
                return;
            }
            Path pluginDataFolder = Path.of(dataFolder, new String[0]);
            Path outputPath = pluginDataFolder.resolve(fileName);
            Files.copy(in, outputPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("\u8d44\u6e90\u6587\u4ef6\u590d\u5236\u6210\u529f");
            Files.move(Path.of(dataFolder + "/assets/toneko/config.yml", new String[0]), Path.of(dataFolder + "/config.yml", new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u590d\u5236\u8d44\u6e90\u6587\u4ef6" + e);
        }
    }

    private void loadLanguageFile() {
        language = config.getString("language");
        Path languageFile = Path.of(dataFolder + "/language/" + language + ".yml", new String[0]);
        if (!Files.exists(languageFile, new LinkOption[0])) {
            this.copyResource("/language/" + language + ".yml", dataFolder + "/language", language + ".yml");
        }
        try {
            languageConfig = new YamlConfiguration(languageFile);
        }
        catch (IOException e) {
            System.out.println("\u65e0\u6cd5\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6:" + e.getMessage());
        }
    }

    static {
        dataFolder = "ctlib/toneko";
    }
}

