/*
 * Decompiled with CFR 0.152.
 */
package com.crystalneko.tonekofabric.util;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.cneko.ctlib.common.file.YamlConfiguration;

public class ConfigUtils {
    public static void updateConfig() throws IOException {
        File backupFile = new File("ctlib/toNeko/config_old.yml");
        File configFile = new File("ctlib/toNeko/config.yml");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        try {
            Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InputStream defaultConfigStream = Resources.getResource((String)"assets/toneko/config.yml").openStream();
        try {
            Files.copy(defaultConfigStream, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File newConfigFile = new File("ctlib/toNeko/config.yml");
        YamlConfiguration newConfig = new YamlConfiguration(newConfigFile);
        newConfig.set("automatic-updates", ConfigUtils.ifConfig("automatic-updates"));
        newConfig.set("language", ConfigUtils.ifConfig("language"));
        newConfig.set("AI.enable", ConfigUtils.ifConfig("AI.enable"));
        newConfig.set("AI.API", ConfigUtils.ifConfig("AI.API"));
        newConfig.set("AI.prompt", ConfigUtils.ifConfig("AI.prompt"));
        newConfig.set("chat.enable", ConfigUtils.ifConfig("chat.enable"));
        newConfig.set("chat.format", ConfigUtils.ifConfig("chat.format"));
        try {
            newConfig.save(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object ifConfig(String option) {
        try {
            File oldConfigFile = new File("ctlib/toNeko/config_old.yml");
            YamlConfiguration oldConfig = new YamlConfiguration(oldConfigFile);
            if (oldConfig.get(option) != null) {
                return oldConfig.get(option);
            }
            File configFile = new File("ctlib/toNeko/config.yml");
            YamlConfiguration config = new YamlConfiguration(configFile);
            return config.get(option);
        }
        catch (IOException e) {
            System.out.println("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
            return null;
        }
    }
}

